/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.RuleScope;
import org.evrete.api.RuntimeContext;
import org.evrete.dsl.AbstractJavaDSLProvider;
import org.evrete.dsl.JavaClassRuleSet;
import org.evrete.util.compiler.BytesClassLoader;

public class JavaDSLJarProvider
extends AbstractJavaDSLProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaDSLJarProvider.class.getName());
    static final String CLASSES_PROPERTY = "org.evrete.dsl.rule-classes";
    private static final String EMPTY_CLASSES = "";
    private static final String CLASS_ENTRY_SUFFIX = ".class";
    private static final String[] DISALLOWED_PACKAGES = new String[]{"java.", "javax.", "sun.", "org.evrete."};

    private static void apply(RuntimeContext<?> targetContext, Set<String> ruleClasses, InputStream ... streams) throws IOException {
        ClassLoader ctxClassLoader = targetContext.getClassLoader();
        ProtectionDomain domain = targetContext.getService().getSecurity().getProtectionDomain(RuleScope.BOTH);
        BytesClassLoader classLoader = new BytesClassLoader(ctxClassLoader, domain);
        JavaDSLJarProvider.fillClassLoader(classLoader, streams);
        for (String ruleClass : ruleClasses) {
            try {
                Class cl = classLoader.loadClass(ruleClass);
                JavaDSLJarProvider.processRuleSet(targetContext, new JavaClassRuleSet(cl));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warning("Ruleset class '" + ruleClass + "' not found");
            }
        }
    }

    public Knowledge create(KnowledgeService service, URL ... resources) throws IOException {
        Knowledge knowledge = service.newKnowledge();
        this.apply((RuntimeContext<?>)knowledge, resources);
        return knowledge;
    }

    private static void fillClassLoader(BytesClassLoader classLoader, InputStream ... resources) throws IOException {
        JarInputStream[] streams = new JarInputStream[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            streams[i] = new JarInputStream(resources[i]);
        }
        JarInputStream[] jarInputStreamArray = streams;
        int n = jarInputStreamArray.length;
        for (int i = 0; i < n; ++i) {
            JarInputStream resource;
            try (JarInputStream is = resource = jarInputStreamArray[i];){
                JavaDSLJarProvider.applyJar(classLoader, is);
                continue;
            }
        }
    }

    private static void applyJar(BytesClassLoader secureClassLoader, JarInputStream is) throws IOException {
        String className;
        JarEntry entry;
        byte[] buffer = new byte[1024];
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        while ((entry = is.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            byte[] bytes = JavaDSLJarProvider.toBytes(is, buffer);
            String name = entry.getName();
            if (name.endsWith(CLASS_ENTRY_SUFFIX)) {
                className = name.substring(0, name.length() - CLASS_ENTRY_SUFFIX.length()).replaceAll("/", ".");
                JavaDSLJarProvider.validateClassName(className);
                classes.put(className, bytes);
                continue;
            }
            resources.put(name, bytes);
        }
        for (Map.Entry e : classes.entrySet()) {
            className = (String)e.getKey();
            byte[] bytes = (byte[])e.getValue();
            try {
                secureClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException cnf) {
                Class clazz = secureClassLoader.buildClass(bytes);
                if (clazz.getName().equals(className)) continue;
                throw new IllegalStateException();
            }
        }
        for (Map.Entry e : resources.entrySet()) {
            secureClassLoader.addResource((String)e.getKey(), (byte[])e.getValue());
        }
    }

    private static Set<String> ruleClasses(RuntimeContext<?> targetContext) {
        HashSet<String> ruleClasses = new HashSet<String>();
        String ruleSets = (String)targetContext.getConfiguration().getOrDefault((Object)CLASSES_PROPERTY, (Object)EMPTY_CLASSES);
        if (!ruleSets.isEmpty()) {
            String[] classNames;
            for (String className : classNames = ruleSets.split("[\\s,;]")) {
                if (className == null || className.isEmpty()) continue;
                ruleClasses.add(className);
            }
        }
        return ruleClasses;
    }

    private static void validateClassName(String className) {
        for (String pkg : DISALLOWED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            throw new IllegalArgumentException("Package name not allowed '" + className + "'");
        }
    }

    private static byte[] toBytes(JarInputStream is, byte[] buffer) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((read = is.read(buffer)) != -1) {
            bos.write(buffer, 0, read);
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    public String getName() {
        return "JAVA-JAR";
    }

    public void apply(RuntimeContext<?> targetContext, InputStream ... streams) throws IOException {
        if (streams == null || streams.length == 0) {
            return;
        }
        Set<String> ruleClasses = JavaDSLJarProvider.ruleClasses(targetContext);
        if (ruleClasses.isEmpty()) {
            LOGGER.warning("No ruleset classes were specified in the 'org.evrete.dsl.rule-classes', resources skipped.");
        } else {
            JavaDSLJarProvider.apply(targetContext, ruleClasses, streams);
        }
    }
}

