/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.reflect.Parameter;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.annotation.Fact;

class LhsParameter {
    static LhsParameter[] EMPTY_ARRAY = new LhsParameter[0];
    final int position;
    final String lhsRef;
    private final Class<?> factType;

    LhsParameter(Parameter parameter, int position) {
        Fact fact = parameter.getAnnotation(Fact.class);
        String ref = fact != null ? fact.value() : parameter.getName();
        if (!ref.startsWith("$")) {
            throw new MalformedResourceException("LHS parameter name '" + parameter.getName() + "' in " + parameter.getDeclaringExecutable().getName() + " can not be correctly derived from Java class meta-data or does not start with '$'. Use the @Fact parameter annotation to specify the correct fact type name.");
        }
        this.position = position;
        this.lhsRef = ref;
        this.factType = LhsParameter.lhsType(parameter);
    }

    private static Class<?> lhsType(Parameter parameter) {
        Class<?> type = parameter.getType();
        if (type.isPrimitive()) {
            switch (type.getName()) {
                case "boolean": {
                    return Boolean.class;
                }
                case "byte": {
                    return Byte.class;
                }
                case "short": {
                    return Short.class;
                }
                case "int": {
                    return Integer.class;
                }
                case "long": {
                    return Long.class;
                }
                case "float": {
                    return Float.class;
                }
                case "double": {
                    return Double.class;
                }
                case "char": {
                    return Character.class;
                }
                case "void": {
                    return Void.class;
                }
            }
            throw new IllegalStateException();
        }
        return type;
    }

    String getLhsRef() {
        return this.lhsRef;
    }

    Class<?> getFactType() {
        return this.factType;
    }
}

