/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.util.List;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.evrete.api.ActivationManager;
import org.evrete.api.ActivationMode;
import org.evrete.api.RuleScope;
import org.evrete.api.RuntimeContext;
import org.evrete.api.RuntimeRule;
import org.evrete.api.StatefulSession;
import org.evrete.dsl.DSLRule;
import org.evrete.dsl.FieldDeclarations;
import org.evrete.dsl.Listeners;
import org.evrete.dsl.Phase;
import org.evrete.dsl.PredicateMethod;
import org.evrete.dsl.RulesetMeta;
import org.evrete.util.SessionWrapper;

class DSLSession
extends SessionWrapper {
    private final Listeners listeners;

    DSLSession(StatefulSession delegate, RulesetMeta meta, FieldDeclarations fieldDeclarations, List<DSLRule> rules, Object classInstance) {
        super(delegate);
        this.listeners = meta.listeners.copy(classInstance);
        fieldDeclarations.applyNormal(this.getTypeResolver(), classInstance);
        for (DSLRule r : rules) {
            RuntimeRule rule = this.getRule(r.ruleMethod.getRuleName());
            rule.setRhs((Consumer)r.ruleMethod.copy(classInstance));
            for (PredicateMethod pm : r.predicateMethods) {
                this.replaceEvaluator(pm.handle, pm.copy(classInstance));
            }
        }
        this.listeners.fire(Phase.CREATE, (RuntimeContext<?>)this);
    }

    public void fire() {
        this.listeners.fire(Phase.FIRE, (RuntimeContext<?>)this);
        super.fire();
    }

    public <T> Future<T> fireAsync(T result) {
        this.listeners.fire(Phase.FIRE, (RuntimeContext<?>)this);
        return super.fireAsync(result);
    }

    public void close() {
        this.listeners.fire(Phase.CLOSE, (RuntimeContext<?>)this);
        super.close();
    }

    public StatefulSession set(String property, Object value) {
        super.set(property, value);
        return this;
    }

    public RuntimeContext<?> addImport(RuleScope scope, String imp) {
        super.addImport(scope, imp);
        return this;
    }

    public StatefulSession setActivationMode(ActivationMode activationMode) {
        super.setActivationMode(activationMode);
        return this;
    }

    public StatefulSession setActivationManager(ActivationManager activationManager) {
        super.setActivationManager(activationManager);
        return this;
    }

    public StatefulSession setFireCriteria(BooleanSupplier fireCriteria) {
        super.setFireCriteria(fireCriteria);
        return this;
    }
}

