/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.RuleScope;
import org.evrete.dsl.AbstractDSLProvider;
import org.evrete.util.compiler.BytesClassLoader;

public class DSLClassProvider
extends AbstractDSLProvider {
    private static Knowledge apply(Knowledge knowledge, byte[][] bytes) {
        ClassLoader ctxClassLoader = knowledge.getClassLoader();
        ProtectionDomain domain = knowledge.getService().getSecurity().getProtectionDomain(RuleScope.BOTH);
        BytesClassLoader loader = new BytesClassLoader(ctxClassLoader, domain);
        Knowledge current = knowledge;
        for (byte[] arr : bytes) {
            current = DSLClassProvider.processRuleSet(current, loader.buildClass(arr));
        }
        return current;
    }

    public String getName() {
        return "JAVA-CLASS";
    }

    public Knowledge create(KnowledgeService service, InputStream ... streams) throws IOException {
        if (streams == null || streams.length == 0) {
            throw new IOException("Empty sources");
        }
        byte[][] bytes = new byte[streams.length][];
        for (int i = 0; i < streams.length; ++i) {
            bytes[i] = DSLClassProvider.toByteArray(streams[i]);
        }
        Knowledge delegate = service.newKnowledge();
        return DSLClassProvider.apply(delegate, bytes);
    }
}

