/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.evrete.Configuration;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.RuleScope;
import org.evrete.dsl.AbstractDSLProvider;
import org.evrete.dsl.Utils;
import org.evrete.util.compiler.BytesClassLoader;

public class DSLJarProvider
extends AbstractDSLProvider {
    static final String CLASSES_PROPERTY = "org.evrete.dsl.rule-classes";
    private static final String EMPTY_CLASSES = "";
    private static final String CLASS_ENTRY_SUFFIX = ".class";
    private static final String[] DISALLOWED_PACKAGES = new String[]{"java.", "javax.", "sun.", "org.evrete."};

    private static Knowledge apply(Knowledge knowledge, Set<String> ruleClasses, InputStream ... streams) throws IOException {
        ClassLoader ctxClassLoader = knowledge.getClassLoader();
        ProtectionDomain domain = knowledge.getService().getSecurity().getProtectionDomain(RuleScope.BOTH);
        BytesClassLoader classLoader = new BytesClassLoader(ctxClassLoader, domain);
        DSLJarProvider.fillClassLoader(classLoader, streams);
        Knowledge current = knowledge;
        for (String ruleClass : ruleClasses) {
            try {
                Class cl = classLoader.loadClass(ruleClass);
                current = DSLJarProvider.processRuleSet(current, cl);
            }
            catch (ClassNotFoundException e) {
                Utils.LOGGER.warning("Ruleset class '" + ruleClass + "' not found");
            }
        }
        return current;
    }

    private static Set<String> ruleClasses(Configuration configuration) {
        HashSet<String> ruleClasses = new HashSet<String>();
        String ruleSets = (String)configuration.getOrDefault((Object)CLASSES_PROPERTY, (Object)EMPTY_CLASSES);
        if (!ruleSets.isEmpty()) {
            String[] classNames;
            for (String className : classNames = ruleSets.split("[\\s,;]")) {
                if (className == null || className.isEmpty()) continue;
                ruleClasses.add(className);
            }
        }
        return ruleClasses;
    }

    private static void fillClassLoader(BytesClassLoader classLoader, InputStream ... resources) throws IOException {
        JarInputStream[] streams = new JarInputStream[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            streams[i] = new JarInputStream(resources[i]);
        }
        JarInputStream[] jarInputStreamArray = streams;
        int n = jarInputStreamArray.length;
        for (int i = 0; i < n; ++i) {
            JarInputStream resource;
            try (JarInputStream is = resource = jarInputStreamArray[i];){
                DSLJarProvider.applyJar(classLoader, is);
                continue;
            }
        }
    }

    private static void applyJar(BytesClassLoader secureClassLoader, JarInputStream is) throws IOException {
        String className;
        JarEntry entry;
        byte[] buffer = new byte[1024];
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        while ((entry = is.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            byte[] bytes = DSLJarProvider.toBytes(is, buffer);
            String name = entry.getName();
            if (name.endsWith(CLASS_ENTRY_SUFFIX)) {
                className = name.substring(0, name.length() - CLASS_ENTRY_SUFFIX.length()).replaceAll("/", ".");
                DSLJarProvider.validateClassName(className);
                classes.put(className, bytes);
                continue;
            }
            resources.put(name, bytes);
        }
        for (Map.Entry e : classes.entrySet()) {
            className = (String)e.getKey();
            byte[] bytes = (byte[])e.getValue();
            try {
                secureClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException cnf) {
                Class clazz = secureClassLoader.buildClass(bytes);
                if (clazz.getName().equals(className)) continue;
                throw new IllegalStateException();
            }
        }
        for (Map.Entry e : resources.entrySet()) {
            secureClassLoader.addResource((String)e.getKey(), (byte[])e.getValue());
        }
    }

    public Knowledge create(KnowledgeService service, InputStream ... streams) throws IOException {
        if (streams == null || streams.length == 0) {
            throw new IOException("Empty streams");
        }
        Set<String> ruleClasses = DSLJarProvider.ruleClasses(service.getConfiguration());
        if (ruleClasses.isEmpty()) {
            Utils.LOGGER.warning("No ruleset classes were specified in the 'org.evrete.dsl.rule-classes', resources skipped.");
        }
        Knowledge knowledge = service.newKnowledge();
        return DSLJarProvider.apply(knowledge, ruleClasses, streams);
    }

    private static void validateClassName(String className) {
        for (String pkg : DISALLOWED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            throw new IllegalArgumentException("Package name not allowed '" + className + "'");
        }
    }

    private static byte[] toBytes(JarInputStream is, byte[] buffer) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((read = is.read(buffer)) != -1) {
            bos.write(buffer, 0, read);
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    public String getName() {
        return "JAVA-JAR";
    }
}

