/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.evrete.api.Evaluator;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.api.Knowledge;
import org.evrete.api.LhsBuilder;
import org.evrete.api.NamedType;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuntimeContext;
import org.evrete.api.StatefulSession;
import org.evrete.api.StatelessSession;
import org.evrete.dsl.ClassMethod;
import org.evrete.dsl.DSLRule;
import org.evrete.dsl.DSLStatefulSession;
import org.evrete.dsl.DSLStatelessSession;
import org.evrete.dsl.FieldDeclarations;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.Phase;
import org.evrete.dsl.PredicateMethod;
import org.evrete.dsl.RuleComparator;
import org.evrete.dsl.RuleMethod;
import org.evrete.dsl.RulesetMeta;
import org.evrete.dsl.Utils;
import org.evrete.dsl.annotation.MethodPredicate;
import org.evrete.dsl.annotation.RuleSet;
import org.evrete.util.KnowledgeWrapper;

class DSLKnowledge
extends KnowledgeWrapper {
    private final Constructor<?> constructor;
    private final RulesetMeta meta;
    private final List<DSLRule> rules = new ArrayList<DSLRule>();

    DSLKnowledge(Knowledge delegate, RulesetMeta meta) {
        super(delegate);
        this.meta = meta;
        try {
            this.constructor = meta.javaClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MalformedResourceException("Unable to locate a zero-arg public constructor in the " + meta.javaClass, e);
        }
        FieldDeclarations fieldDeclarations = meta.fieldDeclarations;
        fieldDeclarations.applyInitial(this.getTypeResolver());
        RuleSet.Sort defaultSort = Utils.deriveSort(meta.javaClass);
        meta.ruleMethods.sort(new RuleComparator(defaultSort));
        for (RuleMethod rm : meta.ruleMethods) {
            RuleBuilder builder = this.newRule(rm.getRuleName());
            if (rm.getSalience() != Integer.MIN_VALUE) {
                builder.salience(rm.getSalience());
            }
            LhsBuilder lhs = builder.getLhs();
            for (RuleMethod.FactDeclaration p : rm.factDeclarations) {
                lhs.addFactDeclaration(p.name, Utils.box(p.type));
            }
            lhs = lhs.where(rm.stringPredicates);
            LinkedList<PredicateMethod> predicateMethods = new LinkedList<PredicateMethod>();
            for (MethodPredicate mp : rm.methodPredicates) {
                String methodName = mp.method();
                FieldReference[] descriptor = this.getExpressionResolver().resolve((NamedType.Resolver)lhs, mp.descriptor());
                Class<?>[] signature = Utils.asMethodSignature(descriptor);
                MethodType methodType = MethodType.methodType(Boolean.TYPE, signature);
                ClassMethod mv = ClassMethod.lookup(meta.lookup, methodName, methodType);
                EvaluatorHandle evaluatorHandle = this.addEvaluator(new DummyEvaluator(descriptor));
                lhs.where(new EvaluatorHandle[]{evaluatorHandle});
                predicateMethods.add(new PredicateMethod(mv, descriptor, evaluatorHandle));
            }
            lhs.execute(c -> {
                throw new IllegalStateException();
            });
            this.rules.add(new DSLRule(rm, predicateMethods));
        }
        meta.listeners.fire(Phase.BUILD, (RuntimeContext<?>)this);
    }

    public StatefulSession newStatefulSession() {
        return new DSLStatefulSession(super.newStatefulSession(), this.meta, this.meta.fieldDeclarations, this.rules, this.classInstance());
    }

    public StatelessSession newStatelessSession() {
        return new DSLStatelessSession(super.newStatelessSession(), this.meta, this.meta.fieldDeclarations, this.rules, this.classInstance());
    }

    private Object classInstance() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new MalformedResourceException("Unable to create instance of the " + this.meta.javaClass, t);
        }
    }

    private static class DummyEvaluator
    implements Evaluator {
        private final FieldReference[] descriptor;

        DummyEvaluator(FieldReference[] descriptor) {
            this.descriptor = descriptor;
        }

        public FieldReference[] descriptor() {
            return this.descriptor;
        }

        public boolean test(IntToValue t) {
            throw new IllegalStateException();
        }
    }
}

