/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.evrete.api.Knowledge;
import org.evrete.api.spi.DSLKnowledgeProvider;
import org.evrete.dsl.DSLKnowledge;
import org.evrete.dsl.RulesetMeta;
import org.evrete.dsl.Utils;
import org.evrete.dsl.annotation.FieldDeclaration;
import org.evrete.dsl.annotation.PhaseListener;
import org.evrete.dsl.annotation.Rule;

abstract class AbstractDSLProvider
implements DSLKnowledgeProvider {
    static final String PROVIDER_JAVA_S = "JAVA-SOURCE";
    static final String PROVIDER_JAVA_C = "JAVA-CLASS";
    static final String PROVIDER_JAVA_J = "JAVA-JAR";

    AbstractDSLProvider() {
    }

    static Knowledge processRuleSet(Knowledge knowledge, Class<?> javaClass) {
        for (Method m : Utils.allNonPublicAnnotated(javaClass)) {
            Utils.LOGGER.warning("Method " + m + " declared in " + m.getDeclaringClass() + " is not public and will be disregarded.");
        }
        RulesetMeta meta = new RulesetMeta(javaClass);
        for (Method m : javaClass.getMethods()) {
            Rule ruleAnnotation = m.getAnnotation(Rule.class);
            PhaseListener listenerAnnotation = m.getAnnotation(PhaseListener.class);
            FieldDeclaration fieldDeclaration = m.getAnnotation(FieldDeclaration.class);
            if (ruleAnnotation != null) {
                meta.addRuleMethod(m);
                continue;
            }
            if (listenerAnnotation != null) {
                meta.addListener(m);
                continue;
            }
            if (fieldDeclaration == null) continue;
            meta.addFieldDeclaration(m, fieldDeclaration.type());
        }
        if (meta.ruleMethods.isEmpty()) {
            Utils.LOGGER.warning("No rule methods found in the source, ruleset is empty");
            return knowledge;
        }
        return new DSLKnowledge(knowledge, meta);
    }

    static String[] toSourceString(Reader[] readers) throws IOException {
        String[] sources = new String[readers.length];
        for (int i = 0; i < readers.length; ++i) {
            String line;
            Reader reader = readers[i];
            BufferedReader bufferedReader = new BufferedReader(reader);
            StringBuilder source = new StringBuilder(4096);
            while ((line = bufferedReader.readLine()) != null) {
                source.append(line).append("\n");
            }
            bufferedReader.close();
            sources[i] = source.toString();
        }
        return sources;
    }

    static String[] toSourceString(Charset charset, InputStream ... streams) throws IOException {
        String[] sources = new String[streams.length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = new String(AbstractDSLProvider.toByteArray(streams[i]), charset);
        }
        return sources;
    }

    static byte[] toByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            bos.write(buffer, 0, length);
        }
        bos.close();
        return bos.toByteArray();
    }
}

