/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.util.List;
import java.util.function.Consumer;
import org.evrete.api.ActivationManager;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeContext;
import org.evrete.api.RuntimeRule;
import org.evrete.dsl.DSLRule;
import org.evrete.dsl.FieldDeclarations;
import org.evrete.dsl.Listeners;
import org.evrete.dsl.Phase;
import org.evrete.dsl.PredicateMethod;
import org.evrete.dsl.RulesetMeta;
import org.evrete.util.AbstractSessionWrapper;

abstract class AbstractDSLSession<S extends RuleSession<S>>
extends AbstractSessionWrapper<S> {
    private final Listeners listeners;

    AbstractDSLSession(S delegate, RulesetMeta meta, FieldDeclarations fieldDeclarations, List<DSLRule> rules, Object classInstance) {
        super(delegate);
        this.listeners = meta.listeners.copy(classInstance);
        fieldDeclarations.applyNormal(this.getTypeResolver(), classInstance);
        for (DSLRule r : rules) {
            RuntimeRule rule = this.getRule(r.ruleMethod.getRuleName());
            rule.setRhs((Consumer)r.ruleMethod.copy(classInstance));
            for (PredicateMethod pm : r.predicateMethods) {
                this.replaceEvaluator(pm.handle, pm.copy(classInstance));
            }
        }
        delegate.addEventListener(evt -> {
            switch (evt) {
                case PRE_FIRE: {
                    this.listeners.fire(Phase.FIRE, (RuntimeContext<?>)this);
                    break;
                }
                case PRE_CLOSE: {
                    this.listeners.fire(Phase.CLOSE, (RuntimeContext<?>)this);
                    break;
                }
            }
        });
        if (classInstance instanceof ActivationManager) {
            this.setActivationManager((ActivationManager)classInstance);
        }
        this.listeners.fire(Phase.CREATE, (RuntimeContext<?>)this);
    }
}

