/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import org.evrete.Configuration;
import org.evrete.api.Environment;
import org.evrete.api.RuntimeContext;
import org.evrete.dsl.ListenerMethod;
import org.evrete.dsl.MaskedEnvironment;
import org.evrete.dsl.Phase;
import org.evrete.dsl.SessionCloneable;

class Listeners
implements SessionCloneable<Listeners> {
    private final EnumMap<Phase, List<ListenerMethod>> listeners = new EnumMap(Phase.class);

    Listeners() {
        for (Phase phase : Phase.values()) {
            this.listeners.put(phase, new LinkedList());
        }
    }

    @Override
    public Listeners copy(Object sessionInstance) {
        Listeners newInstance = new Listeners();
        for (Phase phase : Phase.values()) {
            for (ListenerMethod lm : this.listeners.get((Object)phase)) {
                newInstance.add(phase, lm.copy(sessionInstance));
            }
        }
        return newInstance;
    }

    private void add(Phase phase, ListenerMethod m) {
        this.listeners.get((Object)phase).add(m);
    }

    void add(ListenerMethod m) {
        for (Phase phase : m.phases) {
            this.add(phase, m);
        }
    }

    void fire(Phase phase, RuntimeContext<?> ctx) {
        Collection c = this.listeners.get((Object)phase);
        if (!c.isEmpty()) {
            Configuration configuration = ctx.getConfiguration();
            MaskedEnvironment environment = new MaskedEnvironment((Environment)ctx);
            for (ListenerMethod m : c) {
                m.call(configuration, environment);
            }
        }
    }
}

