/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.ProtectionDomain;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.RuleScope;
import org.evrete.api.TypeResolver;
import org.evrete.dsl.AbstractDSLProvider;
import org.evrete.dsl.Utils;
import org.evrete.util.compiler.CompilationException;
import org.evrete.util.compiler.ServiceClassLoader;
import org.evrete.util.compiler.SourceCompiler;

public class DSLSourceProvider
extends AbstractDSLProvider {
    private static final String CHARSET_PROPERTY = "org.evrete.source-charset";
    private static final String CHARSET_DEFAULT = "UTF-8";

    private static Knowledge build(Knowledge knowledge, String[] sources) {
        ClassLoader ctxClassLoader = knowledge.getClassLoader();
        ProtectionDomain domain = knowledge.getService().getSecurity().getProtectionDomain(RuleScope.BOTH);
        ServiceClassLoader loader = new ServiceClassLoader(ctxClassLoader, domain);
        SourceCompiler compiler = new SourceCompiler();
        Knowledge current = knowledge;
        for (String source : sources) {
            try {
                Class ruleSet = compiler.compile(source, loader);
                current = DSLSourceProvider.processRuleSet(current, ruleSet);
            }
            catch (CompilationException e) {
                Utils.LOGGER.warning("Source code: \n" + e.getSource());
                throw new IllegalStateException(e);
            }
        }
        return current;
    }

    public String getName() {
        return "JAVA-SOURCE";
    }

    public Knowledge create(KnowledgeService service, TypeResolver typeResolver, InputStream ... streams) throws IOException {
        if (streams == null || streams.length == 0) {
            throw new IOException("Empty resources");
        }
        String charSet = service.getConfiguration().getProperty(CHARSET_PROPERTY, CHARSET_DEFAULT);
        Knowledge knowledge = service.newKnowledge(typeResolver);
        return DSLSourceProvider.build(knowledge, DSLSourceProvider.toSourceString(Charset.forName(charSet), streams));
    }

    public Knowledge create(KnowledgeService service, Reader ... readers) throws IOException {
        if (readers == null || readers.length == 0) {
            throw new IOException("Empty resources");
        }
        Knowledge knowledge = service.newKnowledge();
        return DSLSourceProvider.build(knowledge, DSLSourceProvider.toSourceString(readers));
    }
}

