/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.TypeResolver;
import org.evrete.dsl.AbstractDSLProvider;

public class DSLClassProvider
extends AbstractDSLProvider {
    public String getName() {
        return "JAVA-CLASS";
    }

    public Knowledge create(KnowledgeService service, TypeResolver typeResolver, InputStream ... streams) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Knowledge create(KnowledgeService service, URL ... resources) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Knowledge create(KnowledgeService service, TypeResolver typeResolver, URL ... resources) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Knowledge create(KnowledgeService service, InputStream ... streams) throws IOException {
        return super.create(service, streams);
    }

    public Knowledge create(KnowledgeService service, Reader ... streams) throws IOException {
        return super.create(service, streams);
    }

    public Knowledge create(KnowledgeService service, TypeResolver typeResolver, Reader ... streams) throws IOException {
        Class<?>[] classes = DSLClassProvider.loadClasses(service, streams);
        Knowledge current = service.newKnowledge(typeResolver);
        for (Class<?> cl : classes) {
            current = DSLClassProvider.processRuleSet(current, cl);
        }
        return current;
    }

    private static Class<?>[] loadClasses(KnowledgeService service, Reader ... streams) throws IOException {
        Class[] classes = new Class[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            BufferedReader br = new BufferedReader(streams[i]);
            String className = br.readLine();
            try {
                classes[i] = service.getClassLoader().loadClass(className);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to load class '" + className + "'", e);
            }
        }
        return classes;
    }
}

