/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.evrete.Configuration;
import org.evrete.api.Environment;
import org.evrete.dsl.ClassMethod;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.Phase;
import org.evrete.dsl.SessionCloneable;
import org.evrete.dsl.annotation.PhaseListener;

class PhaseListenerMethod
extends ClassMethod
implements SessionCloneable<PhaseListenerMethod> {
    final Set<Phase> phases = EnumSet.noneOf(Phase.class);
    private int configIndex;
    private int environmentIndex;

    PhaseListenerMethod(MethodHandles.Lookup lookup, Method method) {
        super(lookup, method);
        PhaseListener listener = Objects.requireNonNull(method.getAnnotation(PhaseListener.class));
        Collections.addAll(this.phases, listener.value());
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new MalformedResourceException("Listener methods must be void. " + method);
        }
        if (this.phases.contains((Object)Phase.BUILD) && !this.staticMethod) {
            throw new MalformedResourceException((Object)((Object)Phase.BUILD) + " is bound to a non-static method " + method + " of " + method.getDeclaringClass());
        }
        this.configIndex = -1;
        this.environmentIndex = -1;
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> type = parameters[i].getType();
            if (Configuration.class.isAssignableFrom(type)) {
                if (this.configIndex < 0) {
                    this.configIndex = i;
                    continue;
                }
                throw new MalformedResourceException("Duplicate configuration argument in " + method);
            }
            if (Environment.class.isAssignableFrom(type)) {
                if (this.environmentIndex < 0) {
                    this.environmentIndex = i;
                    continue;
                }
                throw new MalformedResourceException("Duplicate environment argument in " + method);
            }
            throw new MalformedResourceException("Illegal argument type in " + method + " : " + type);
        }
    }

    private PhaseListenerMethod(PhaseListenerMethod method, Object instance) {
        super(method, instance);
        this.configIndex = method.configIndex;
        this.environmentIndex = method.environmentIndex;
    }

    void call(Configuration configuration, Environment environment) {
        if (this.configIndex >= 0) {
            this.args[this.configIndex] = configuration;
        }
        if (this.environmentIndex >= 0) {
            this.args[this.environmentIndex] = environment;
        }
        this.call();
    }

    @Override
    public PhaseListenerMethod copy(Object sessionInstance) {
        return new PhaseListenerMethod(this, sessionInstance);
    }
}

