/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.evrete.dsl.EnvListenerMethod;
import org.evrete.dsl.EnvListeners;
import org.evrete.dsl.FieldDeclarationMethod;
import org.evrete.dsl.FieldDeclarations;
import org.evrete.dsl.PhaseListenerMethod;
import org.evrete.dsl.PhaseListeners;
import org.evrete.dsl.RuleMethod;

class RulesetMeta {
    final PhaseListeners phaseListeners = new PhaseListeners();
    final EnvListeners envListeners = new EnvListeners();
    final FieldDeclarations fieldDeclarations = new FieldDeclarations();
    final MethodHandles.Lookup lookup;
    final Class<?> javaClass;
    List<RuleMethod> ruleMethods = new ArrayList<RuleMethod>();

    RulesetMeta(Class<?> javaClass) {
        this.lookup = MethodHandles.lookup().in(javaClass);
        this.javaClass = javaClass;
    }

    void addPhaseListener(Method m) {
        PhaseListenerMethod lm = new PhaseListenerMethod(this.lookup, m);
        this.phaseListeners.add(lm);
    }

    void addRuleMethod(Method m) {
        this.ruleMethods.add(new RuleMethod(this.lookup, m));
    }

    void addFieldDeclaration(Method method, String type) {
        this.fieldDeclarations.addFieldDeclaration(new FieldDeclarationMethod(this.lookup, method, type));
    }

    void addEnvListener(Method method, String property) {
        this.envListeners.add(property, new EnvListenerMethod(this.lookup, method));
    }
}

