/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.util.List;
import java.util.function.Consumer;
import org.evrete.api.ActivationManager;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeContext;
import org.evrete.api.RuntimeRule;
import org.evrete.dsl.DSLRule;
import org.evrete.dsl.EnvListeners;
import org.evrete.dsl.FieldDeclarations;
import org.evrete.dsl.Phase;
import org.evrete.dsl.PhaseListeners;
import org.evrete.dsl.PredicateMethod;
import org.evrete.dsl.RulesetMeta;
import org.evrete.util.AbstractSessionWrapper;

abstract class AbstractDSLSession<S extends RuleSession<S>>
extends AbstractSessionWrapper<S> {
    private final PhaseListeners phaseListeners;
    private final EnvListeners envListeners;

    AbstractDSLSession(S delegate, RulesetMeta meta, FieldDeclarations fieldDeclarations, List<DSLRule> rules, Object classInstance) {
        super(delegate);
        this.phaseListeners = meta.phaseListeners.copy(classInstance);
        this.envListeners = meta.envListeners.copy(classInstance);
        fieldDeclarations.applyNormal(this.getTypeResolver(), classInstance);
        for (DSLRule r : rules) {
            RuntimeRule rule = (RuntimeRule)this.getRule(r.ruleMethod.getRuleName());
            rule.setRhs((Consumer)r.ruleMethod.copy(classInstance));
            for (PredicateMethod pm : r.predicateMethods) {
                this.replaceEvaluator(pm.handle, pm.copy(classInstance));
            }
        }
        delegate.addEventListener(evt -> {
            switch (evt) {
                case PRE_FIRE: {
                    this.phaseListeners.fire(Phase.FIRE, (RuntimeContext<?>)this);
                    break;
                }
                case PRE_CLOSE: {
                    this.phaseListeners.fire(Phase.CLOSE, (RuntimeContext<?>)this);
                    break;
                }
            }
        });
        if (classInstance instanceof ActivationManager) {
            this.setActivationManager((ActivationManager)classInstance);
        }
        this.phaseListeners.fire(Phase.CREATE, (RuntimeContext<?>)this);
    }

    public S set(String property, Object value) {
        super.set(property, value);
        this.envListeners.fire(property, value, false);
        return (S)((Object)this);
    }
}

