/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import org.evrete.api.TypeResolver;
import org.evrete.dsl.ClassMethod;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.SessionCloneable;
import org.evrete.dsl.annotation.FieldDeclaration;

class FieldDeclarationMethod<T, V>
extends ClassMethod
implements SessionCloneable<FieldDeclarationMethod<T, V>> {
    final Class<T> factType;
    final String fieldName;
    private final Class<V> fieldType;
    private final String typeName;

    FieldDeclarationMethod(MethodHandles.Lookup lookup, Method method, String typeName) {
        super(lookup, method);
        FieldDeclaration ann = Objects.requireNonNull(method.getAnnotation(FieldDeclaration.class));
        String declaredName = ann.name().trim();
        this.fieldName = declaredName.isEmpty() ? method.getName() : declaredName;
        this.fieldType = method.getReturnType();
        if (this.fieldType.equals(Void.TYPE) || this.fieldType.equals(Void.class)) {
            throw new MalformedResourceException("Method " + method + " in the " + method.getDeclaringClass() + " is annotated as field declaration but is void");
        }
        Parameter[] parameters = method.getParameters();
        if (parameters.length != 1) {
            throw new MalformedResourceException("Method " + method + " in the " + method.getDeclaringClass() + " is annotated as field declaration but has zero or more than one parameters");
        }
        this.factType = parameters[0].getType();
        this.typeName = typeName == null || typeName.isEmpty() ? this.factType.getName() : typeName;
    }

    private FieldDeclarationMethod(FieldDeclarationMethod<T, V> method, Object instance) {
        super(method, instance);
        this.fieldType = method.fieldType;
        this.factType = method.factType;
        this.fieldName = method.fieldName;
        this.typeName = method.typeName;
    }

    @Override
    public FieldDeclarationMethod<T, V> copy(Object sessionInstance) {
        return new FieldDeclarationMethod<T, V>(this, sessionInstance);
    }

    void applyNormal(TypeResolver resolver) {
        resolver.getOrDeclare(this.typeName, this.factType).declareField(this.fieldName, this.fieldType, this.asFunction());
    }

    void applyInitial(TypeResolver resolver) {
        resolver.getOrDeclare(this.typeName, this.factType).declareField(this.fieldName, this.fieldType, t -> {
            throw new IllegalStateException();
        });
    }
}

