/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Logger;
import org.evrete.api.FieldReference;
import org.evrete.dsl.annotation.Fact;
import org.evrete.dsl.annotation.FieldDeclaration;
import org.evrete.dsl.annotation.PhaseListener;
import org.evrete.dsl.annotation.Rule;
import org.evrete.dsl.annotation.RuleSet;
import org.evrete.dsl.annotation.Where;

public final class Utils {
    static final Logger LOGGER = Logger.getLogger(Utils.class.getPackage().getName());

    static Collection<Method> allNonPublicAnnotated(Class<?> clazz) {
        Class<?> current = clazz;
        HashSet<Method> methods = new HashSet<Method>();
        if (clazz.equals(Object.class)) {
            return methods;
        }
        while (!current.equals(Object.class)) {
            for (Method m : current.getDeclaredMethods()) {
                if (!Utils.hasDslAnnotation(m) || Modifier.isPublic(m.getModifiers())) continue;
                methods.add(m);
            }
            current = current.getSuperclass();
        }
        return methods;
    }

    static String factName(Parameter parameter) {
        Fact fact = parameter.getAnnotation(Fact.class);
        if (fact != null) {
            return fact.value();
        }
        return parameter.getName();
    }

    static String factType(Parameter parameter) {
        Fact fact = parameter.getAnnotation(Fact.class);
        if (fact == null || fact.type().isEmpty()) {
            return null;
        }
        return fact.type();
    }

    static Class<?>[] asMethodSignature(FieldReference[] references) {
        Class[] signature = new Class[references.length];
        for (int i = 0; i < references.length; ++i) {
            signature[i] = references[i].field().getValueType();
        }
        return signature;
    }

    private static boolean hasDslAnnotation(Method m) {
        return m.getAnnotation(Rule.class) != null || m.getAnnotation(PhaseListener.class) != null || m.getAnnotation(Where.class) != null || m.getAnnotation(FieldDeclaration.class) != null;
    }

    static RuleSet.Sort deriveSort(Class<?> clazz) {
        RuleSet.Sort sort = Utils.searchSort(clazz);
        return sort == null ? RuleSet.Sort.DEFAULT : sort;
    }

    static String ruleName(Method method) {
        Rule ruleAnn = Objects.requireNonNull(method.getAnnotation(Rule.class));
        String name = ruleAnn.value().trim();
        if (name.isEmpty()) {
            return method.getName();
        }
        return name;
    }

    static int salience(Method method) {
        return Objects.requireNonNull(method.getAnnotation(Rule.class)).salience();
    }

    private static RuleSet.Sort searchSort(Class<?> clazz) {
        RuleSet policy = clazz.getAnnotation(RuleSet.class);
        if (policy != null) {
            return policy.defaultSort();
        }
        Class<?> parent = clazz.getSuperclass();
        if (parent.equals(Object.class)) {
            return null;
        }
        return Utils.searchSort(parent);
    }

    static Class<?> box(Class<?> type) {
        if (type.isPrimitive()) {
            switch (type.getName()) {
                case "boolean": {
                    return Boolean.class;
                }
                case "byte": {
                    return Byte.class;
                }
                case "short": {
                    return Short.class;
                }
                case "int": {
                    return Integer.class;
                }
                case "long": {
                    return Long.class;
                }
                case "float": {
                    return Float.class;
                }
                case "double": {
                    return Double.class;
                }
                case "char": {
                    return Character.class;
                }
                case "void": {
                    return Void.class;
                }
            }
            throw new IllegalStateException();
        }
        return type;
    }
}

