/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.evrete.api.Evaluator;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.api.Knowledge;
import org.evrete.api.NamedType;
import org.evrete.api.RuntimeContext;
import org.evrete.api.StatefulSession;
import org.evrete.api.StatelessSession;
import org.evrete.api.builders.LhsBuilder;
import org.evrete.api.builders.RuleBuilder;
import org.evrete.api.builders.RuleSetBuilder;
import org.evrete.dsl.ClassMethod;
import org.evrete.dsl.DSLRule;
import org.evrete.dsl.DSLStatefulSession;
import org.evrete.dsl.DSLStatelessSession;
import org.evrete.dsl.FieldDeclarations;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.Phase;
import org.evrete.dsl.PredicateMethod;
import org.evrete.dsl.RuleComparator;
import org.evrete.dsl.RuleMethod;
import org.evrete.dsl.RulesetMeta;
import org.evrete.dsl.Utils;
import org.evrete.dsl.annotation.MethodPredicate;
import org.evrete.dsl.annotation.RuleSet;
import org.evrete.util.KnowledgeWrapper;

class DSLKnowledge
extends KnowledgeWrapper {
    private final Constructor<?> constructor;
    private final RulesetMeta meta;
    private final List<DSLRule> rules = new ArrayList<DSLRule>();

    DSLKnowledge(Knowledge delegate, RulesetMeta meta) {
        super(delegate);
        this.meta = meta;
        try {
            this.constructor = meta.javaClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MalformedResourceException("Unable to locate a zero-arg public constructor in the " + meta.javaClass, e);
        }
        FieldDeclarations fieldDeclarations = meta.fieldDeclarations;
        fieldDeclarations.applyInitial(this.getTypeResolver());
        RuleSet.Sort defaultSort = Utils.deriveSort(meta.javaClass);
        meta.ruleMethods.sort(new RuleComparator(defaultSort));
        RuleSetBuilder rulesetBuilder = this.builder();
        for (RuleMethod rm : meta.ruleMethods) {
            String currentRuleBaseClass = delegate.getConfiguration().getProperty("evrete.impl.rule-base-class");
            delegate.getConfiguration().setProperty("evrete.impl.rule-base-class", DSLKnowledge.canonicalName(meta.javaClass));
            RuleBuilder builder = rulesetBuilder.newRule(rm.getRuleName()).property("evrete.impl.rule-base-class", (Object)DSLKnowledge.canonicalName(meta.javaClass));
            if (rm.getSalience() != Integer.MIN_VALUE) {
                builder.salience(rm.getSalience());
            }
            LhsBuilder lhs = builder.getLhs();
            for (RuleMethod.FactDeclaration p : rm.factDeclarations) {
                Class<?> cl = Utils.box(p.javaType);
                if (p.namedType == null) {
                    lhs.addFactDeclaration(p.name, cl);
                    continue;
                }
                lhs.addFactDeclaration(p.name, p.namedType);
            }
            lhs.where(rm.stringPredicates);
            LinkedList<PredicateMethod> predicateMethods = new LinkedList<PredicateMethod>();
            for (MethodPredicate mp : rm.methodPredicates) {
                String methodName = mp.method();
                String[] args = mp.args();
                FieldReference[] descriptor = this.getExpressionResolver().resolve((NamedType.Resolver)lhs, args);
                Class<?>[] signature = Utils.asMethodSignature(descriptor);
                MethodType methodType = MethodType.methodType(Boolean.TYPE, signature);
                ClassMethod mv = ClassMethod.lookup(meta.lookup, methodName, methodType);
                EvaluatorHandle evaluatorHandle = this.addEvaluator(new DummyEvaluator(descriptor));
                lhs.where(new EvaluatorHandle[]{evaluatorHandle});
                predicateMethods.add(new PredicateMethod(mv, descriptor, evaluatorHandle));
            }
            lhs.execute(c -> {
                throw new IllegalStateException();
            });
            this.rules.add(new DSLRule(rm, predicateMethods));
            if (currentRuleBaseClass == null) continue;
            delegate.getConfiguration().setProperty("evrete.impl.rule-base-class", currentRuleBaseClass);
        }
        rulesetBuilder.build();
        meta.phaseListeners.fire(Phase.BUILD, (RuntimeContext<?>)this);
    }

    private static String canonicalName(Class<?> cl) {
        try {
            return cl.getCanonicalName();
        }
        catch (Throwable t) {
            return cl.getName().replaceAll("\\$", ".");
        }
    }

    public StatefulSession newStatefulSession() {
        return new DSLStatefulSession(super.newStatefulSession(), this.meta, this.meta.fieldDeclarations, this.rules, this.classInstance());
    }

    public StatelessSession newStatelessSession() {
        return new DSLStatelessSession(super.newStatelessSession(), this.meta, this.meta.fieldDeclarations, this.rules, this.classInstance());
    }

    public Knowledge set(String property, Object value) {
        super.set(property, value);
        this.meta.envListeners.fire(property, value, true);
        return this;
    }

    private Object classInstance() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new MalformedResourceException("Unable to create instance of the " + this.meta.javaClass, t);
        }
    }

    private static class DummyEvaluator
    implements Evaluator {
        private final FieldReference[] descriptor;

        DummyEvaluator(FieldReference[] descriptor) {
            this.descriptor = descriptor;
        }

        public FieldReference[] descriptor() {
            return this.descriptor;
        }

        public boolean test(IntToValue t) {
            throw new IllegalStateException();
        }
    }
}

