/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.evrete.api.RhsContext;
import org.evrete.dsl.ClassMethod;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.SessionCloneable;
import org.evrete.dsl.Utils;
import org.evrete.dsl.annotation.MethodPredicate;
import org.evrete.dsl.annotation.Where;

class RuleMethod
extends ClassMethod
implements SessionCloneable<RuleMethod>,
Consumer<RhsContext> {
    final String[] stringPredicates;
    final MethodPredicate[] methodPredicates;
    final FactDeclaration[] factDeclarations;
    private final int contextParamId;
    private final int salience;
    private final String ruleName;

    RuleMethod(MethodHandles.Lookup lookup, Method method) {
        super(lookup, method);
        this.salience = Utils.salience(method);
        this.ruleName = Utils.ruleName(method);
        Where predicates = method.getAnnotation(Where.class);
        if (predicates == null) {
            this.stringPredicates = new String[0];
            this.methodPredicates = new MethodPredicate[0];
        } else {
            this.stringPredicates = predicates.value();
            this.methodPredicates = predicates.methods();
        }
        int ctxIndex = Integer.MIN_VALUE;
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new MalformedResourceException("Rule methods must be void. " + String.valueOf(method));
        }
        Parameter[] parameters = method.getParameters();
        ArrayList<FactDeclaration> rhsParameterList = new ArrayList<FactDeclaration>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            if (RhsContext.class.isAssignableFrom(param.getType())) {
                if (ctxIndex < 0) {
                    ctxIndex = i;
                    continue;
                }
                throw new MalformedResourceException("Duplicate context parameter in " + method.getName());
            }
            FactDeclaration rhsParameter = new FactDeclaration(param, i);
            rhsParameterList.add(rhsParameter);
        }
        this.factDeclarations = rhsParameterList.toArray(FactDeclaration.EMPTY);
        this.contextParamId = ctxIndex;
    }

    private RuleMethod(RuleMethod other, Object instance) {
        super(other, instance);
        this.contextParamId = other.contextParamId;
        this.salience = other.salience;
        this.ruleName = other.ruleName;
        this.stringPredicates = other.stringPredicates;
        this.methodPredicates = other.methodPredicates;
        this.factDeclarations = other.factDeclarations;
    }

    @Override
    public RuleMethod copy(Object sessionInstance) {
        return new RuleMethod(this, sessionInstance);
    }

    String getRuleName() {
        return this.ruleName;
    }

    int getSalience() {
        return this.salience;
    }

    @Override
    public void accept(RhsContext ctx) {
        for (FactDeclaration p : this.factDeclarations) {
            this.args[p.position] = ctx.getObject(p.name);
        }
        if (this.contextParamId >= 0) {
            this.args[this.contextParamId] = ctx;
        }
        this.call();
    }

    static class FactDeclaration {
        static final FactDeclaration[] EMPTY = new FactDeclaration[0];
        final int position;
        final String name;
        final Class<?> javaType;
        final String namedType;

        FactDeclaration(Parameter parameter, int position) {
            this.name = Utils.factName(parameter);
            this.position = position;
            this.javaType = parameter.getType();
            this.namedType = Utils.factType(parameter);
        }
    }
}

