/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.evrete.Configuration;
import org.evrete.KnowledgeService;
import org.evrete.api.JavaSourceCompiler;
import org.evrete.api.Knowledge;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeResolver;
import org.evrete.dsl.AbstractDSLProvider;
import org.evrete.dsl.Utils;
import org.evrete.dsl.annotation.RuleSet;

public class DSLJarProvider
extends AbstractDSLProvider {
    static final String CLASSES_PROPERTY = "org.evrete.dsl.rule-classes";
    private static final String EMPTY_CLASSES = "";
    private static final String CLASS_ENTRY_SUFFIX = ".class";
    private static final String[] DISALLOWED_PACKAGES = new String[]{"java.", "javax.", "sun.", "org.evrete."};

    private static Knowledge apply(Knowledge knowledge, MethodHandles.Lookup lookup, Set<String> ruleClasses, InputStream ... streams) throws IOException {
        List<Class<?>> jarClasses = DSLJarProvider.fillClassLoader(knowledge, streams);
        Knowledge current = knowledge;
        if (ruleClasses.isEmpty()) {
            if (jarClasses.isEmpty()) {
                Utils.LOGGER.warning("Classes annotated with @" + RuleSet.class.getSimpleName() + " not found");
                return knowledge;
            }
            for (Class<?> cl : jarClasses) {
                current = DSLJarProvider.processRuleSet(current, lookup, cl);
            }
        } else {
            for (String ruleClass : ruleClasses) {
                try {
                    Class<?> cl = current.getClassLoader().loadClass(ruleClass);
                    current = DSLJarProvider.processRuleSet(current, lookup, cl);
                }
                catch (ClassNotFoundException e) {
                    Utils.LOGGER.warning("Ruleset class '" + ruleClass + "' not found");
                }
            }
        }
        return current;
    }

    private static Set<String> ruleClasses(Configuration configuration) {
        HashSet<String> ruleClasses = new HashSet<String>();
        String ruleSets = (String)configuration.getOrDefault((Object)CLASSES_PROPERTY, (Object)EMPTY_CLASSES);
        if (!ruleSets.isEmpty()) {
            String[] classNames;
            for (String className : classNames = ruleSets.split("[\\s,;]")) {
                if (className == null || className.isEmpty()) continue;
                ruleClasses.add(className);
            }
        }
        return ruleClasses;
    }

    private static List<Class<?>> fillClassLoader(RuntimeContext<?> ctx, InputStream ... resources) throws IOException {
        JarInputStream[] streams = new JarInputStream[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            streams[i] = new JarInputStream(resources[i]);
        }
        LinkedList ruleSets = new LinkedList();
        JarInputStream[] jarInputStreamArray = streams;
        int n = jarInputStreamArray.length;
        for (int i = 0; i < n; ++i) {
            JarInputStream resource;
            try (JarInputStream is = resource = jarInputStreamArray[i];){
                List<Class<?>> jarRuleSets = DSLJarProvider.applyJar(ctx, is);
                ruleSets.addAll(jarRuleSets);
                continue;
            }
        }
        return ruleSets;
    }

    private static List<Class<?>> applyJar(RuntimeContext<?> ctx, JarInputStream is) throws IOException {
        String className;
        JarEntry entry;
        JavaSourceCompiler compiler = ctx.getSourceCompiler();
        byte[] buffer = new byte[1024];
        HashMap<String, Object> classes = new HashMap<String, Object>();
        while ((entry = is.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            Object bytes = DSLJarProvider.toBytes(is, buffer);
            String string = entry.getName();
            if (!string.endsWith(CLASS_ENTRY_SUFFIX)) continue;
            className = string.substring(0, string.length() - CLASS_ENTRY_SUFFIX.length()).replaceAll("/", ".");
            DSLJarProvider.validateClassName(className);
            classes.put(className, bytes);
        }
        for (Map.Entry entry2 : classes.entrySet()) {
            className = (String)entry2.getKey();
            byte[] bytes = (byte[])entry2.getValue();
            compiler.defineClass(className, bytes);
        }
        LinkedList allClasses = new LinkedList();
        for (String classNme : classes.keySet()) {
            try {
                allClasses.add(ctx.getClassLoader().loadClass(classNme));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class '" + classNme + "' couldn't be loaded", e);
            }
        }
        return allClasses;
    }

    private static void validateClassName(String className) {
        for (String pkg : DISALLOWED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            throw new IllegalArgumentException("Package name not allowed '" + className + "'");
        }
    }

    private static byte[] toBytes(JarInputStream is, byte[] buffer) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((read = is.read(buffer)) != -1) {
            bos.write(buffer, 0, read);
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    public Knowledge create(KnowledgeService service, TypeResolver typeResolver, InputStream ... streams) throws IOException {
        if (streams == null || streams.length == 0) {
            throw new IOException("Empty streams");
        }
        Set<String> ruleClasses = DSLJarProvider.ruleClasses(service.getConfiguration());
        Knowledge knowledge = service.newKnowledge(typeResolver);
        MethodHandles.Lookup lookup = this.defaultLookup();
        return DSLJarProvider.apply(knowledge, lookup, ruleClasses, streams);
    }

    public String getName() {
        return "JAVA-JAR";
    }
}

