/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.evrete.api.RuntimeContext;
import org.evrete.api.spi.SourceCompiler;
import org.evrete.dsl.AbstractDSLProvider;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.ResourceClasses;
import org.evrete.util.CommonUtils;
import org.evrete.util.CompilationException;
import org.evrete.util.JavaSourceUtils;

public class DSLSourceProvider
extends AbstractDSLProvider {
    private static final Logger LOGGER = Logger.getLogger(DSLSourceProvider.class.getName());
    private static final Class<?>[] SUPPORTED_TYPES = new Class[]{TYPE_INPUT_STREAM, TYPE_URL, TYPE_READER, TYPE_CHAR_SEQUENCE, TYPE_FILE};

    @Override
    public Set<Class<?>> sourceTypes() {
        return Set.of(SUPPORTED_TYPES);
    }

    public String getName() {
        return "JAVA-SOURCE";
    }

    @Override
    <C extends RuntimeContext<C>> ResourceClasses createFromURLs(RuntimeContext<C> context, Collection<URL> resources) throws IOException {
        Charset charset = DSLSourceProvider.charset(context.getConfiguration());
        ArrayList<String> sources = new ArrayList<String>(resources.size());
        for (URL resource : resources) {
            sources.add(DSLSourceProvider.toSourceString(charset, resource));
        }
        return this.createClassMetaFromSource(context, sources);
    }

    @Override
    <C extends RuntimeContext<C>> ResourceClasses createFromReaders(RuntimeContext<C> context, Collection<Reader> resources) throws IOException {
        ArrayList<String> sources = new ArrayList<String>(resources.size());
        for (Reader reader : resources) {
            sources.add(DSLSourceProvider.toSourceString(reader));
        }
        return this.createClassMetaFromSource(context, sources);
    }

    @Override
    <C extends RuntimeContext<C>> ResourceClasses createFromStrings(RuntimeContext<C> context, Collection<CharSequence> resources) {
        ArrayList<String> sources = new ArrayList<String>(resources.size());
        for (CharSequence resource : resources) {
            sources.add(resource.toString());
        }
        return this.createClassMetaFromSource(context, sources);
    }

    @Override
    <C extends RuntimeContext<C>> ResourceClasses createFromStreams(RuntimeContext<C> context, Collection<InputStream> resources) throws IOException {
        Charset charset = DSLSourceProvider.charset(context.getConfiguration());
        ArrayList<String> sources = new ArrayList<String>(resources.size());
        for (InputStream stream : resources) {
            sources.add(DSLSourceProvider.toSourceString(charset, stream));
        }
        return this.createClassMetaFromSource(context, sources);
    }

    @Override
    <C extends RuntimeContext<C>> ResourceClasses createFromFiles(RuntimeContext<C> context, Collection<File> resources) throws IOException {
        return this.createFromURLs(context, DSLSourceProvider.toURLs(resources));
    }

    private <C extends RuntimeContext<C>> ResourceClasses createClassMetaFromSource(RuntimeContext<C> context, Collection<String> sources) {
        SourceCompiler sourceCompiler = context.getService().getSourceCompilerProvider().instance(context.getClassLoader());
        ArrayList<SourceCompiler.ClassSource> compilationUnits = new ArrayList<SourceCompiler.ClassSource>(sources.size());
        IdentityHashMap<SourceCompiler.ClassSource, Class> map = new IdentityHashMap<SourceCompiler.ClassSource, Class>();
        for (String string : sources) {
            SourceCompiler.ClassSource classSource = JavaSourceUtils.parse((String)string);
            compilationUnits.add(classSource);
        }
        assert (compilationUnits.size() == sources.size());
        try {
            Collection compiled = sourceCompiler.compile(compilationUnits);
            for (Object result : compiled) {
                map.put(result.getSource(), result.getCompiledClass());
            }
            ArrayList arrayList = new ArrayList(compiled.size());
            for (SourceCompiler.ClassSource classSource : compilationUnits) {
                Class clazz = (Class)map.get(classSource);
                LOGGER.fine(() -> "New class has been compiled and selected '" + clazz.getName() + "'");
                arrayList.add(clazz);
            }
            if (arrayList.isEmpty()) {
                LOGGER.warning("No classes were compiled");
                return null;
            }
            ClassLoader classLoader = ((Class)arrayList.iterator().next()).getClassLoader();
            return new ResourceClasses(classLoader, arrayList);
        }
        catch (CompilationException e) {
            e.log(LOGGER, Level.SEVERE);
            throw new MalformedResourceException("Unable to compile source(s)", e);
        }
    }

    private static String toSourceString(Reader reader) throws IOException {
        return CommonUtils.toString((Reader)reader);
    }

    private static String toSourceString(Charset charset, InputStream stream) throws IOException {
        return new String(CommonUtils.toByteArrayChecked((InputStream)stream), charset);
    }

    private static String toSourceString(Charset charset, URL url) throws IOException {
        try (InputStream is = url.openStream();){
            String string = DSLSourceProvider.toSourceString(charset, is);
            return string;
        }
    }
}

