/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.evrete.api.RhsContext;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.RuleMethod;
import org.evrete.dsl.WrappedClass;
import org.evrete.dsl.WrappedCloneableMethod;

class WrappedRhsMethod
extends WrappedCloneableMethod<WrappedRhsMethod>
implements Consumer<RhsContext> {
    final RuleMethod.FactDeclaration[] factDeclarations;
    private final int contextParamId;

    public WrappedRhsMethod(WrappedClass declaringClass, Method delegate) {
        super(declaringClass, delegate);
        int ctxIndex = Integer.MIN_VALUE;
        if (!delegate.getReturnType().equals(Void.TYPE)) {
            throw new MalformedResourceException("Rule methods must be void: " + String.valueOf(delegate));
        }
        ArrayList<RuleMethod.FactDeclaration> rhsParameterList = new ArrayList<RuleMethod.FactDeclaration>();
        Parameter[] parameters = delegate.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            if (RhsContext.class.isAssignableFrom(param.getType())) {
                if (ctxIndex < 0) {
                    ctxIndex = i;
                    continue;
                }
                throw new MalformedResourceException("Duplicate context parameter in " + delegate.getName());
            }
            RuleMethod.FactDeclaration rhsParameter = new RuleMethod.FactDeclaration(param, i);
            rhsParameterList.add(rhsParameter);
        }
        this.factDeclarations = rhsParameterList.toArray(RuleMethod.FactDeclaration.EMPTY);
        this.contextParamId = ctxIndex;
    }

    public WrappedRhsMethod(WrappedRhsMethod other, Object bindInstance) {
        super(other, bindInstance);
        this.factDeclarations = other.factDeclarations;
        this.contextParamId = other.contextParamId;
    }

    @Override
    WrappedRhsMethod bindTo(Object classInstance) {
        return new WrappedRhsMethod(this, classInstance);
    }

    @Override
    public void accept(RhsContext ctx) {
        for (RuleMethod.FactDeclaration p : this.factDeclarations) {
            this.args[p.position] = ctx.getObject(p.name);
        }
        if (this.contextParamId >= 0) {
            this.args[this.contextParamId] = ctx;
        }
        this.call();
    }
}

