/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.EvaluatorsContext;
import org.evrete.api.Rule;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeResolver;
import org.evrete.api.ValuesPredicate;
import org.evrete.dsl.WrappedCloneableMethod;
import org.evrete.dsl.WrappedConditionMethod;
import org.evrete.dsl.WrappedEventSubscriptionMethod;
import org.evrete.dsl.WrappedFieldDeclarationMethod;
import org.evrete.dsl.WrappedMethod;
import org.evrete.dsl.WrappedRhsMethod;

class MetadataCollector {
    final Set<Class<?>> classesToInstantiate = new HashSet();
    final Map<Class<?>, Collection<RhsUpdate>> rhsUpdateTasks = new HashMap();
    final Map<Class<?>, Collection<ConditionUpdate>> conditionUpdateTasks = new HashMap();
    final Map<Class<?>, Collection<WrappedFieldDeclarationMethod<?, ?>>> fieldDeclarationMethods = new HashMap();
    final Map<Class<?>, Collection<WrappedEventSubscriptionMethod<?>>> eventSubscriptionMethods = new HashMap();

    MetadataCollector() {
    }

    void scheduleConditionMethodUpdate(EvaluatorHandle evaluatorHandle, WrappedConditionMethod condition) {
        this.conditionUpdateTasks.computeIfAbsent(this.registerKey(condition), k -> new LinkedList()).add(new ConditionUpdate(evaluatorHandle, condition));
    }

    void scheduleRhsMethodUpdate(String ruleName, WrappedRhsMethod rhs) {
        this.rhsUpdateTasks.computeIfAbsent(this.registerKey(rhs), k -> new LinkedList()).add(new RhsUpdate(ruleName, rhs));
    }

    void addFieldDeclarationMethod(WrappedFieldDeclarationMethod<?, ?> method) {
        this.fieldDeclarationMethods.computeIfAbsent(this.registerKey(method), k -> new LinkedList()).add(method);
    }

    void addEventSubscriptionMethod(WrappedEventSubscriptionMethod<?> method) {
        this.eventSubscriptionMethods.computeIfAbsent(this.registerKey(method), k -> new LinkedList()).add(method);
    }

    private Class<?> registerKey(WrappedMethod method) {
        Class<?> key = method.declaringClass.delegate;
        this.classesToInstantiate.add(key);
        return key;
    }

    void applyToSession(RuleSession<?> newSession) {
        Object instance;
        HashMap instances = new HashMap(this.classesToInstantiate.size());
        for (Class<?> clazz : this.classesToInstantiate) {
            try {
                Object newInstance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                instances.put(clazz, newInstance);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create class instance", e);
            }
        }
        for (Map.Entry entry : this.rhsUpdateTasks.entrySet()) {
            instance = instances.get(entry.getKey());
            for (Object rhsUpdate : (Collection)entry.getValue()) {
                Rule rule = newSession.getRule(((RhsUpdate)rhsUpdate).ruleName);
                if (rule == null) continue;
                rule.setRhs((Consumer)((RhsUpdate)rhsUpdate).rhs.bindTo(instance));
            }
        }
        for (Map.Entry entry : this.conditionUpdateTasks.entrySet()) {
            instance = instances.get(entry.getKey());
            EvaluatorsContext evaluatorsContext = newSession.getEvaluatorsContext();
            for (ConditionUpdate conditionUpdate : (Collection)entry.getValue()) {
                evaluatorsContext.replacePredicate(conditionUpdate.evaluatorHandle, (ValuesPredicate)conditionUpdate.condition.bindTo(instance));
            }
        }
        for (Map.Entry entry : this.fieldDeclarationMethods.entrySet()) {
            instance = instances.get(entry.getKey());
            for (WrappedCloneableMethod fieldDeclaration : (Collection)entry.getValue()) {
                newSession.configureTypes(arg_0 -> MetadataCollector.lambda$applyToSession$4((WrappedFieldDeclarationMethod)fieldDeclaration, instance, arg_0));
            }
        }
        for (Map.Entry entry : this.eventSubscriptionMethods.entrySet()) {
            instance = instances.get(entry.getKey());
            for (WrappedCloneableMethod fieldDeclaration : (Collection)entry.getValue()) {
                newSession.configureTypes(arg_0 -> MetadataCollector.lambda$applyToSession$5((WrappedEventSubscriptionMethod)fieldDeclaration, instance, newSession, arg_0));
            }
        }
    }

    private static /* synthetic */ void lambda$applyToSession$5(WrappedEventSubscriptionMethod fieldDeclaration, Object instance, RuleSession newSession, TypeResolver typeResolver) {
        ((WrappedEventSubscriptionMethod)fieldDeclaration.bindTo(instance)).selfSubscribe((RuntimeContext<?>)newSession);
    }

    private static /* synthetic */ void lambda$applyToSession$4(WrappedFieldDeclarationMethod fieldDeclaration, Object instance, TypeResolver typeResolver) {
        ((WrappedFieldDeclarationMethod)fieldDeclaration.bindTo(instance)).selfRegister(typeResolver);
    }

    static class ConditionUpdate {
        final EvaluatorHandle evaluatorHandle;
        final WrappedConditionMethod condition;

        ConditionUpdate(EvaluatorHandle evaluatorHandle, WrappedConditionMethod condition) {
            this.evaluatorHandle = evaluatorHandle;
            this.condition = condition;
        }
    }

    static class RhsUpdate {
        final String ruleName;
        final WrappedRhsMethod rhs;

        public RhsUpdate(String ruleName, WrappedRhsMethod rhs) {
            this.ruleName = ruleName;
            this.rhs = rhs;
        }
    }
}

