/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.util.CommonUtils;

class ResourceCollection {
    private final Class<?> type;
    private final Collection<Object> resources;

    <T> Collection<T> cast() {
        ArrayList<Object> result = new ArrayList<Object>(this.resources.size());
        for (Object resource : this.resources) {
            result.add(resource);
        }
        return result;
    }

    ResourceCollection(Class<?> type, Collection<Object> resources) {
        this.type = type;
        this.resources = resources;
    }

    Class<?> getComponentType() {
        return this.type;
    }

    static ResourceCollection factory(Object o) {
        Collection col = CommonUtils.toCollection((Object)o);
        if (col.isEmpty()) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(col.size());
        Iterator<Object> it = col.iterator();
        Object first = it.next();
        result.add(first);
        Class<?> type = first.getClass();
        it.forEachRemaining(object -> {
            if (object != null) {
                Class<?> c = object.getClass();
                if (c.isAssignableFrom(type)) {
                    result.add(object);
                } else {
                    throw new MalformedResourceException("Cannot cast " + String.valueOf(object) + " to " + String.valueOf(type));
                }
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return new ResourceCollection(type, result);
    }
}

