/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.jsr94;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.jsr94.RuleExecutionSetImpl;
import org.evrete.jsr94.Utils;

class LocalRuleExecutionSetProviderImpl
implements LocalRuleExecutionSetProvider {
    private final KnowledgeService knowledgeService;

    LocalRuleExecutionSetProviderImpl(KnowledgeService knowledgeService) {
        this.knowledgeService = knowledgeService;
    }

    public RuleExecutionSet createRuleExecutionSet(InputStream inputStream, Map map) throws RuleExecutionSetCreateException, IOException {
        String dsl = Utils.getStringProperty(map, "org.evrete.jsr94.dsl-name");
        if (dsl == null) {
            throw new RuleExecutionSetCreateException("Missing DSL name property 'org.evrete.jsr94.dsl-name'");
        }
        try {
            Knowledge knowledge = this.knowledgeService.newKnowledge();
            Utils.copyConfiguration(knowledge, map);
            knowledge.appendDslRules(dsl, new InputStream[]{inputStream});
            return new RuleExecutionSetImpl(knowledge, map);
        }
        catch (RuntimeException e) {
            throw new RuleExecutionSetCreateException("Unable to create RuleExecutionSet", (Exception)e);
        }
    }

    public RuleExecutionSet createRuleExecutionSet(Reader reader, Map map) throws RuleExecutionSetCreateException, IOException {
        String dsl = Utils.getStringProperty(map, "org.evrete.jsr94.dsl-name");
        if (dsl == null) {
            throw new RuleExecutionSetCreateException("Missing DSL name property 'org.evrete.jsr94.dsl-name'");
        }
        try {
            Knowledge knowledge = this.knowledgeService.newKnowledge();
            Utils.copyConfiguration(knowledge, map);
            knowledge.appendDslRules(dsl, new Reader[]{reader});
            return new RuleExecutionSetImpl(knowledge, map);
        }
        catch (RuntimeException e) {
            throw new RuleExecutionSetCreateException("Unable to create RuleExecutionSet", (Exception)e);
        }
    }

    public RuleExecutionSet createRuleExecutionSet(Object o, Map map) throws RuleExecutionSetCreateException {
        throw new RuleExecutionSetCreateException("Unsupported by " + this.getClass().getName());
    }
}

