/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.jsr94;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.RuleRuntime;
import javax.rules.RuleSession;
import javax.rules.RuleSessionCreateException;
import javax.rules.RuleSessionTypeUnsupportedException;
import org.evrete.api.StatefulSession;
import org.evrete.jsr94.RuleExecutionSetImpl;
import org.evrete.jsr94.RuleExecutionSetMetadataImpl;
import org.evrete.jsr94.RuleSetRegistrations;
import org.evrete.jsr94.StatefulSessionImpl;
import org.evrete.jsr94.StatelessSessionImpl;
import org.evrete.jsr94.Utils;

class RuleRuntimeImpl
implements RuleRuntime {
    private static final long serialVersionUID = -1999541474405198310L;
    private final RuleSetRegistrations registrations;

    RuleRuntimeImpl(RuleSetRegistrations registrations) {
        this.registrations = registrations;
    }

    public RuleSession createRuleSession(String s, Map map, int i) throws RuleSessionTypeUnsupportedException, RuleSessionCreateException, RuleExecutionSetNotFoundException {
        RuleExecutionSetMetadataImpl metadata;
        StatefulSession delegate;
        RuleExecutionSetImpl set = this.registrations.getChecked(s);
        try {
            delegate = set.getKnowledge().newStatefulSession();
            Utils.copyConfiguration(delegate, map);
            metadata = new RuleExecutionSetMetadataImpl(s, delegate);
        }
        catch (Exception e) {
            throw new RuleSessionCreateException(e.getMessage(), e);
        }
        switch (i) {
            case 0: {
                return new StatefulSessionImpl(delegate, metadata);
            }
            case 1: {
                return new StatelessSessionImpl(delegate, metadata);
            }
        }
        throw new RuleSessionTypeUnsupportedException("Session type " + i + " is not supported. Supported values are [" + 0 + "] (stateful session) and [" + 1 + "] (stateless session)");
    }

    public List<?> getRegistrations() {
        return this.registrations.getKeys();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new UnsupportedOperationException("Serialization not supported");
    }
}

