/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.jsr94;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.rules.Handle;
import javax.rules.InvalidHandleException;
import javax.rules.InvalidRuleSessionException;
import javax.rules.ObjectFilter;
import javax.rules.StatefulRuleSession;
import org.evrete.api.FactHandle;
import org.evrete.api.StatefulSession;
import org.evrete.jsr94.AbstractRuleSessionBase;
import org.evrete.jsr94.HandleImpl;
import org.evrete.jsr94.RuleExecutionSetMetadataImpl;
import org.evrete.jsr94.Utils;

public class StatefulRuleSessionImpl
extends AbstractRuleSessionBase
implements StatefulRuleSession {
    private static final long serialVersionUID = 1640888587580047958L;

    StatefulRuleSessionImpl(StatefulSession delegate, RuleExecutionSetMetadataImpl metadata) {
        super(delegate, 0, metadata);
    }

    public boolean containsObject(Handle handle) throws InvalidRuleSessionException, InvalidHandleException {
        Object o = this.getObject(handle);
        return o != null;
    }

    public Handle addObject(Object o) throws InvalidRuleSessionException {
        FactHandle h = this.delegate.insert(o);
        if (h == null) {
            throw new InvalidRuleSessionException("Handle not created, inserted object is of unknown type.");
        }
        return new HandleImpl(h);
    }

    public List<?> addObjects(List list) throws InvalidRuleSessionException {
        if (list == null || list.isEmpty()) {
            return HandleImpl.EMPTY_LIST;
        }
        ArrayList<HandleImpl> handles = new ArrayList<HandleImpl>(list.size());
        for (Object o : list) {
            try {
                handles.add(new HandleImpl(this.delegate.insert(o)));
            }
            catch (Exception e) {
                throw new InvalidRuleSessionException(e.getMessage(), e);
            }
        }
        return handles;
    }

    public void updateObject(Handle handle, Object o) throws InvalidRuleSessionException, InvalidHandleException {
        if (handle instanceof HandleImpl) {
            HandleImpl h = (HandleImpl)handle;
            try {
                this.delegate.update(h.delegate, o);
            }
            catch (Exception t) {
                throw new InvalidRuleSessionException(t.getMessage(), t);
            }
        } else {
            throw new InvalidHandleException("Invalid fact handle instance");
        }
    }

    public void removeObject(Handle handle) throws InvalidHandleException, InvalidRuleSessionException {
        if (handle instanceof HandleImpl) {
            HandleImpl h = (HandleImpl)handle;
            try {
                this.delegate.delete(h.delegate);
            }
            catch (Exception t) {
                throw new InvalidRuleSessionException(t.getMessage(), t);
            }
        } else {
            throw new InvalidHandleException("Invalid fact handle instance");
        }
    }

    public List<?> getObjects() throws InvalidRuleSessionException {
        return Utils.sessionObjects(this.delegate);
    }

    public List<Handle> getHandles() {
        LinkedList<Handle> list = new LinkedList<Handle>();
        this.delegate.forEachFact((handle, o) -> list.add(new HandleImpl((FactHandle)handle)));
        return list;
    }

    public List<?> getObjects(ObjectFilter objectFilter) throws InvalidRuleSessionException {
        return this.getObjects().stream().map(arg_0 -> ((ObjectFilter)objectFilter).filter(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void executeRules() throws InvalidRuleSessionException {
        try {
            this.delegate.fire();
        }
        catch (Exception e) {
            throw new InvalidRuleSessionException(e.getMessage(), e);
        }
    }

    public void reset() throws InvalidRuleSessionException {
        try {
            this.delegate.clear();
        }
        catch (Exception e) {
            throw new InvalidRuleSessionException(e.getMessage(), e);
        }
    }

    public Object getObject(Handle handle) throws InvalidHandleException, InvalidRuleSessionException {
        if (handle instanceof HandleImpl) {
            HandleImpl h = (HandleImpl)handle;
            try {
                return this.delegate.getFact(h.delegate);
            }
            catch (Exception t) {
                throw new InvalidRuleSessionException(t.getMessage(), t);
            }
        }
        throw new InvalidHandleException("Invalid fact handle");
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new UnsupportedOperationException("Serialization not supported");
    }
}

