/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.jsr94;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import javax.rules.admin.RuleExecutionSetProvider;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.jsr94.RuleExecutionSetImpl;
import org.evrete.jsr94.Utils;
import org.w3c.dom.Element;

class RuleExecutionSetProviderImpl
implements RuleExecutionSetProvider {
    private final KnowledgeService knowledgeService;

    RuleExecutionSetProviderImpl(KnowledgeService knowledgeService) {
        this.knowledgeService = knowledgeService;
    }

    public RuleExecutionSet createRuleExecutionSet(Element element, Map map) {
        throw new UnsupportedOperationException("DOM elements are not directly supported, available DSL providers should parse documents as streams or URLs.");
    }

    public RuleExecutionSet createRuleExecutionSet(Serializable serializable, Map map) throws RuleExecutionSetCreateException {
        if (serializable instanceof String) {
            return this.createRuleExecutionSet(serializable, map);
        }
        if (serializable instanceof URL) {
            URL url = (URL)serializable;
            try {
                return this.createRuleExecutionSet(map, url);
            }
            catch (IOException e) {
                throw new RuleExecutionSetCreateException("Unable to create ruleset from URL", (Exception)e);
            }
        }
        if (serializable instanceof URL[]) {
            URL[] urls = (URL[])serializable;
            try {
                return this.createRuleExecutionSet(map, urls);
            }
            catch (IOException e) {
                throw new RuleExecutionSetCreateException("Unable to create ruleset from URL[]", (Exception)e);
            }
        }
        if (serializable instanceof URI) {
            URI uri = (URI)serializable;
            try {
                URL url = uri.toURL();
                return this.createRuleExecutionSet(map, url);
            }
            catch (IOException e) {
                throw new RuleExecutionSetCreateException("Unable to create ruleset from URI", (Exception)e);
            }
        }
        if (serializable instanceof URI[]) {
            URI[] uris = (URI[])serializable;
            try {
                URL[] urls = new URL[uris.length];
                for (int i = 0; i < uris.length; ++i) {
                    urls[i] = uris[i].toURL();
                }
                return this.createRuleExecutionSet(map, urls);
            }
            catch (IOException e) {
                throw new RuleExecutionSetCreateException("Unable to create ruleset from URI[]", (Exception)e);
            }
        }
        if (serializable instanceof File) {
            File file = (File)serializable;
            try {
                URL url = file.toURI().toURL();
                return this.createRuleExecutionSet(map, url);
            }
            catch (IOException e) {
                throw new RuleExecutionSetCreateException("Unable to create ruleset from File", (Exception)e);
            }
        }
        if (serializable instanceof File[]) {
            File[] files = (File[])serializable;
            try {
                URL[] urls = new URL[files.length];
                for (int i = 0; i < files.length; ++i) {
                    urls[i] = files[i].toURI().toURL();
                }
                return this.createRuleExecutionSet(map, urls);
            }
            catch (IOException e) {
                throw new RuleExecutionSetCreateException("Unable to create ruleset from File[]", (Exception)e);
            }
        }
        throw new RuleExecutionSetCreateException("Unable to create ruleset, unsupported serializable");
    }

    public RuleExecutionSet createRuleExecutionSet(String s, Map map) throws RuleExecutionSetCreateException, IOException {
        String dsl = Utils.dslName(map);
        try {
            Knowledge knowledge = this.knowledgeService.newKnowledge(dsl, new Reader[]{new StringReader(s)});
            return new RuleExecutionSetImpl(knowledge, map);
        }
        catch (RuntimeException e) {
            throw new RuleExecutionSetCreateException("Unable to create RuleExecutionSet", (Exception)e);
        }
    }

    private RuleExecutionSet createRuleExecutionSet(Map<?, ?> map, URL ... urls) throws RuleExecutionSetCreateException, IOException {
        String dsl = Utils.dslName(map);
        try {
            Knowledge knowledge = this.knowledgeService.newKnowledge(dsl, urls);
            return new RuleExecutionSetImpl(knowledge, map);
        }
        catch (RuntimeException e) {
            throw new RuleExecutionSetCreateException("Unable to create RuleExecutionSet", (Exception)e);
        }
    }
}

