/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.jsr94;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.rules.InvalidRuleSessionException;
import javax.rules.admin.RuleExecutionSetCreateException;
import org.evrete.api.RuntimeContext;
import org.evrete.api.StatefulSession;

final class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    Utils() {
    }

    static void setProperty(RuntimeContext<?> ctx, Object key, Object value) {
        if (key == null) {
            LOGGER.warning("Null property keys are not supported");
        }
        if (key instanceof String) {
            ctx.set((String)key, value);
        } else {
            LOGGER.warning("Non-string property keys are not supported");
        }
    }

    static Object getProperty(RuntimeContext<?> ctx, Object key) {
        if (key instanceof String) {
            return ctx.get((String)key);
        }
        LOGGER.warning("Non-string property keys are not supported");
        return null;
    }

    static String dslName(Map map) throws RuleExecutionSetCreateException {
        Object o = map.get("org.evrete.jsr94.dsl-name");
        if (o instanceof String) {
            return (String)o;
        }
        throw new RuleExecutionSetCreateException("Missing DSL name property 'org.evrete.jsr94.dsl-name'");
    }

    static List<?> sessionObjects(StatefulSession delegate) throws InvalidRuleSessionException {
        try {
            LinkedList response = new LinkedList();
            delegate.forEachFact((handle, o) -> response.add(o));
            return response;
        }
        catch (Exception e) {
            throw new InvalidRuleSessionException(e.getMessage(), e);
        }
    }

    static void copyConfiguration(RuntimeContext<?> destination, Map<?, ?> from) {
        if (from != null) {
            from.forEach((key, val) -> {
                if (key instanceof String && val instanceof String) {
                    destination.getConfiguration().setProperty((String)key, (String)val);
                }
            });
        }
    }
}

