/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.cdi.test.impl.event;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import java.util.HashSet;
import java.util.Set;
import org.eximeebpms.bpm.engine.cdi.BusinessProcessEvent;
import org.eximeebpms.bpm.engine.cdi.annotation.event.AssignTask;
import org.eximeebpms.bpm.engine.cdi.annotation.event.BusinessProcessDefinition;
import org.eximeebpms.bpm.engine.cdi.annotation.event.CompleteTask;
import org.eximeebpms.bpm.engine.cdi.annotation.event.CreateTask;
import org.eximeebpms.bpm.engine.cdi.annotation.event.DeleteTask;
import org.eximeebpms.bpm.engine.cdi.annotation.event.EndActivity;
import org.eximeebpms.bpm.engine.cdi.annotation.event.StartActivity;
import org.eximeebpms.bpm.engine.cdi.annotation.event.TakeTransition;
import org.junit.Assert;

@ApplicationScoped
public class TestEventListener {
    private final Set<BusinessProcessEvent> eventsReceivedByKey = new HashSet<BusinessProcessEvent>();
    private final Set<BusinessProcessEvent> eventsReceived = new HashSet<BusinessProcessEvent>();
    private int startActivityService1 = 0;
    private int endActivityService1 = 0;
    private int takeTransition1 = 0;
    private int createTaskUser1 = 0;
    private int assignTaskUser1 = 0;
    private int completeTaskUser1 = 0;
    private int deleteTaskUser1 = 0;

    public void reset() {
        this.startActivityService1 = 0;
        this.endActivityService1 = 0;
        this.takeTransition1 = 0;
        this.createTaskUser1 = 0;
        this.assignTaskUser1 = 0;
        this.completeTaskUser1 = 0;
        this.deleteTaskUser1 = 0;
        this.eventsReceivedByKey.clear();
        this.eventsReceived.clear();
    }

    public void onProcessEventByKey(@Observes @BusinessProcessDefinition(value="process1") BusinessProcessEvent businessProcessEvent) {
        Assert.assertNotNull((Object)businessProcessEvent);
        Assert.assertEquals((Object)"process1", (Object)businessProcessEvent.getProcessDefinition().getKey());
        this.eventsReceivedByKey.add(businessProcessEvent);
    }

    public Set<BusinessProcessEvent> getEventsReceivedByKey() {
        return this.eventsReceivedByKey;
    }

    public void onProcessEvent(@Observes BusinessProcessEvent businessProcessEvent) {
        Assert.assertNotNull((Object)businessProcessEvent);
        this.eventsReceived.add(businessProcessEvent);
    }

    public Set<BusinessProcessEvent> getEventsReceived() {
        return this.eventsReceived;
    }

    public void onStartActivityService1(@Observes @StartActivity(value="service1") BusinessProcessEvent businessProcessEvent) {
        Assert.assertEquals((Object)"service1", (Object)businessProcessEvent.getActivityId());
        Assert.assertNotNull((Object)businessProcessEvent);
        Assert.assertNull((Object)businessProcessEvent.getTask());
        Assert.assertNull((Object)businessProcessEvent.getTaskId());
        Assert.assertNull((Object)businessProcessEvent.getTaskDefinitionKey());
        ++this.startActivityService1;
    }

    public void onEndActivityService1(@Observes @EndActivity(value="service1") BusinessProcessEvent businessProcessEvent) {
        Assert.assertEquals((Object)"service1", (Object)businessProcessEvent.getActivityId());
        Assert.assertNotNull((Object)businessProcessEvent);
        Assert.assertNull((Object)businessProcessEvent.getTask());
        Assert.assertNull((Object)businessProcessEvent.getTaskId());
        Assert.assertNull((Object)businessProcessEvent.getTaskDefinitionKey());
        ++this.endActivityService1;
    }

    public void takeTransition1(@Observes @TakeTransition(value="t1") BusinessProcessEvent businessProcessEvent) {
        Assert.assertEquals((Object)"t1", (Object)businessProcessEvent.getTransitionName());
        Assert.assertNotNull((Object)businessProcessEvent);
        Assert.assertNull((Object)businessProcessEvent.getTask());
        Assert.assertNull((Object)businessProcessEvent.getTaskId());
        Assert.assertNull((Object)businessProcessEvent.getTaskDefinitionKey());
        ++this.takeTransition1;
    }

    public int getEndActivityService1() {
        return this.endActivityService1;
    }

    public int getStartActivityService1() {
        return this.startActivityService1;
    }

    public int getTakeTransition1() {
        return this.takeTransition1;
    }

    public void onCreateTask(@Observes @CreateTask(value="user1") BusinessProcessEvent businessProcessEvent) {
        Assert.assertNotNull((Object)businessProcessEvent);
        Assert.assertNotNull((Object)businessProcessEvent.getTask());
        Assert.assertNotNull((Object)businessProcessEvent.getTaskId());
        Assert.assertEquals((Object)"user1", (Object)businessProcessEvent.getTaskDefinitionKey());
        ++this.createTaskUser1;
    }

    public void onAssignTask(@Observes @AssignTask(value="user1") BusinessProcessEvent businessProcessEvent) {
        Assert.assertNotNull((Object)businessProcessEvent);
        Assert.assertNotNull((Object)businessProcessEvent.getTask());
        Assert.assertNotNull((Object)businessProcessEvent.getTaskId());
        Assert.assertEquals((Object)"user1", (Object)businessProcessEvent.getTaskDefinitionKey());
        ++this.assignTaskUser1;
    }

    public void onCompleteTask(@Observes @CompleteTask(value="user1") BusinessProcessEvent businessProcessEvent) {
        Assert.assertNotNull((Object)businessProcessEvent);
        Assert.assertNotNull((Object)businessProcessEvent.getTask());
        Assert.assertNotNull((Object)businessProcessEvent.getTaskId());
        Assert.assertEquals((Object)"user1", (Object)businessProcessEvent.getTaskDefinitionKey());
        ++this.completeTaskUser1;
    }

    public void onDeleteTask(@Observes @DeleteTask(value="user1") BusinessProcessEvent businessProcessEvent) {
        Assert.assertNotNull((Object)businessProcessEvent);
        Assert.assertNotNull((Object)businessProcessEvent.getTask());
        Assert.assertNotNull((Object)businessProcessEvent.getTaskId());
        Assert.assertEquals((Object)"user1", (Object)businessProcessEvent.getTaskDefinitionKey());
        ++this.deleteTaskUser1;
    }

    public int getCreateTaskUser1() {
        return this.createTaskUser1;
    }

    public int getAssignTaskUser1() {
        return this.assignTaskUser1;
    }

    public int getCompleteTaskUser1() {
        return this.completeTaskUser1;
    }

    public int getDeleteTaskUser1() {
        return this.deleteTaskUser1;
    }
}

