/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.cdi.test.impl.event;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eximeebpms.bpm.engine.cdi.BusinessProcessEvent;
import org.eximeebpms.bpm.engine.cdi.test.CdiProcessEngineTestCase;
import org.eximeebpms.bpm.engine.cdi.test.impl.event.TestEventListener;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class EventNotificationTest
extends CdiProcessEngineTestCase {
    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/cdi/test/impl/event/EventNotificationTest.process1.bpmn20.xml"})
    public void testReceiveAll() {
        TestEventListener listenerBean = this.getBeanInstance(TestEventListener.class);
        listenerBean.reset();
        Assert.assertEquals((long)0L, (long)listenerBean.getEventsReceived().size());
        this.runtimeService.startProcessInstanceByKey("process1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)16L, (long)listenerBean.getEventsReceived().size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/cdi/test/impl/event/EventNotificationTest.process1.bpmn20.xml", "org/eximeebpms/bpm/engine/cdi/test/impl/event/EventNotificationTest.process2.bpmn20.xml"})
    public void testSelectEventsPerProcessDefinition() {
        TestEventListener listenerBean = this.getBeanInstance(TestEventListener.class);
        listenerBean.reset();
        Assert.assertEquals((long)0L, (long)listenerBean.getEventsReceivedByKey().size());
        this.runtimeService.startProcessInstanceByKey("process1");
        this.runtimeService.startProcessInstanceByKey("process2");
        Assert.assertEquals((long)11L, (long)listenerBean.getEventsReceivedByKey().size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/cdi/test/impl/event/EventNotificationTest.process1.bpmn20.xml"})
    public void testSelectEventsPerActivity() {
        TestEventListener listenerBean = this.getBeanInstance(TestEventListener.class);
        listenerBean.reset();
        Assert.assertEquals((long)0L, (long)listenerBean.getEndActivityService1());
        Assert.assertEquals((long)0L, (long)listenerBean.getStartActivityService1());
        Assert.assertEquals((long)0L, (long)listenerBean.getTakeTransition1());
        this.runtimeService.startProcessInstanceByKey("process1");
        Assert.assertEquals((long)1L, (long)listenerBean.getEndActivityService1());
        Assert.assertEquals((long)1L, (long)listenerBean.getStartActivityService1());
        Assert.assertEquals((long)1L, (long)listenerBean.getTakeTransition1());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/cdi/test/impl/event/EventNotificationTest.process1.bpmn20.xml"})
    public void testSelectEventsPerTask() {
        TestEventListener listenerBean = this.getBeanInstance(TestEventListener.class);
        listenerBean.reset();
        Assert.assertEquals((long)0L, (long)listenerBean.getCreateTaskUser1());
        Assert.assertEquals((long)0L, (long)listenerBean.getAssignTaskUser1());
        Assert.assertEquals((long)0L, (long)listenerBean.getCompleteTaskUser1());
        Assert.assertEquals((long)0L, (long)listenerBean.getDeleteTaskUser1());
        Assert.assertEquals((long)0L, (long)listenerBean.getEventsReceived().size());
        this.runtimeService.startProcessInstanceByKey("process1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), "demo");
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)listenerBean.getCreateTaskUser1());
        Assert.assertEquals((long)1L, (long)listenerBean.getAssignTaskUser1());
        Assert.assertEquals((long)1L, (long)listenerBean.getCompleteTaskUser1());
        Assert.assertEquals((long)0L, (long)listenerBean.getDeleteTaskUser1());
        listenerBean.reset();
        Assert.assertEquals((long)0L, (long)listenerBean.getDeleteTaskUser1());
        Assert.assertEquals((long)0L, (long)listenerBean.getEventsReceived().size());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process1");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        Assert.assertEquals((long)1L, (long)listenerBean.getDeleteTaskUser1());
    }

    @Test
    @Deployment
    public void testMultiInstanceEvents() {
        TestEventListener listenerBean = this.getBeanInstance(TestEventListener.class);
        listenerBean.reset();
        Assert.assertThat((Object)listenerBean.getEventsReceived().size(), (Matcher)CoreMatchers.is((Object)0));
        this.runtimeService.startProcessInstanceByKey("process1");
        this.waitForJobExecutorToProcessAllJobs(TimeUnit.SECONDS.toMillis(5L), 500L);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"User Task"));
        Assert.assertThat((Object)listenerBean.getEventsReceived().size(), (Matcher)CoreMatchers.is((Object)19));
    }

    @Test
    @Deployment
    public void testMultiInstanceEventsAfterExternalTrigger() {
        this.runtimeService.startProcessInstanceByKey("process");
        TestEventListener listenerBean = this.getBeanInstance(TestEventListener.class);
        listenerBean.reset();
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        Set<BusinessProcessEvent> eventsReceived = listenerBean.getEventsReceived();
        Assert.assertThat((Object)eventsReceived.size(), (Matcher)CoreMatchers.is((Object)10));
    }
}

