/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.cdi;

import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eximeebpms.bpm.engine.cdi.BusinessProcess;
import org.eximeebpms.bpm.engine.cdi.annotation.ProcessVariable;
import org.eximeebpms.bpm.engine.cdi.annotation.ProcessVariableLocal;
import org.eximeebpms.bpm.engine.cdi.annotation.ProcessVariableLocalTyped;
import org.eximeebpms.bpm.engine.cdi.annotation.ProcessVariableTyped;
import org.eximeebpms.bpm.engine.cdi.impl.ProcessVariableLocalMap;
import org.eximeebpms.bpm.engine.cdi.impl.ProcessVariableMap;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;

public class ProcessVariables {
    private Logger logger = Logger.getLogger(ProcessVariables.class.getName());
    @Inject
    private BusinessProcess businessProcess;
    @Inject
    private ProcessVariableMap processVariableMap;
    @Inject
    private ProcessVariableLocalMap processVariableLocalMap;

    protected String getVariableName(InjectionPoint ip) {
        String variableName = ((ProcessVariable)ip.getAnnotated().getAnnotation(ProcessVariable.class)).value();
        if (variableName.length() == 0) {
            variableName = ip.getMember().getName();
        }
        return variableName;
    }

    protected String getVariableTypedName(InjectionPoint ip) {
        String variableName = ((ProcessVariableTyped)ip.getAnnotated().getAnnotation(ProcessVariableTyped.class)).value();
        if (variableName.length() == 0) {
            variableName = ip.getMember().getName();
        }
        return variableName;
    }

    @Produces
    @ProcessVariable
    protected Object getProcessVariable(InjectionPoint ip) {
        String processVariableName = this.getVariableName(ip);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Getting process variable '" + processVariableName + "' from ProcessInstance[" + this.businessProcess.getProcessInstanceId() + "].");
        }
        return this.businessProcess.getVariable(processVariableName);
    }

    @Produces
    @ProcessVariableTyped
    protected TypedValue getProcessVariableTyped(InjectionPoint ip) {
        String processVariableName = this.getVariableTypedName(ip);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Getting typed process variable '" + processVariableName + "' from ProcessInstance[" + this.businessProcess.getProcessInstanceId() + "].");
        }
        return this.businessProcess.getVariableTyped(processVariableName);
    }

    @Produces
    @Named
    protected Map<String, Object> processVariables() {
        return this.processVariableMap;
    }

    @Produces
    @Named
    protected VariableMap processVariableMap() {
        return this.processVariableMap;
    }

    protected String getVariableLocalName(InjectionPoint ip) {
        String variableName = ((ProcessVariableLocal)ip.getAnnotated().getAnnotation(ProcessVariableLocal.class)).value();
        if (variableName.length() == 0) {
            variableName = ip.getMember().getName();
        }
        return variableName;
    }

    protected String getVariableLocalTypedName(InjectionPoint ip) {
        String variableName = ((ProcessVariableLocalTyped)ip.getAnnotated().getAnnotation(ProcessVariableLocalTyped.class)).value();
        if (variableName.length() == 0) {
            variableName = ip.getMember().getName();
        }
        return variableName;
    }

    @Produces
    @ProcessVariableLocal
    protected Object getProcessVariableLocal(InjectionPoint ip) {
        String processVariableName = this.getVariableLocalName(ip);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Getting local process variable '" + processVariableName + "' from ProcessInstance[" + this.businessProcess.getProcessInstanceId() + "].");
        }
        return this.businessProcess.getVariableLocal(processVariableName);
    }

    @Produces
    @ProcessVariableLocalTyped
    protected TypedValue getProcessVariableLocalTyped(InjectionPoint ip) {
        String processVariableName = this.getVariableLocalTypedName(ip);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Getting local typed process variable '" + processVariableName + "' from ProcessInstance[" + this.businessProcess.getProcessInstanceId() + "].");
        }
        return this.businessProcess.getVariableLocalTyped(processVariableName);
    }

    @Produces
    @Named
    protected Map<String, Object> processVariablesLocal() {
        return this.processVariableLocalMap;
    }

    @Produces
    @Named
    protected VariableMap processVariableMapLocal() {
        return this.processVariableLocalMap;
    }
}

