/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.cdi.impl.context;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.cdi.ProcessEngineCdiException;
import org.eximeebpms.bpm.engine.cdi.impl.context.ContextAssociationManager;
import org.eximeebpms.bpm.engine.cdi.impl.context.ConversationScopedAssociation;
import org.eximeebpms.bpm.engine.cdi.impl.context.RequestScopedAssociation;
import org.eximeebpms.bpm.engine.cdi.impl.context.ScopedAssociation;
import org.eximeebpms.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;
import org.eximeebpms.bpm.engine.impl.context.BpmnExecutionContext;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.runtime.Execution;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;

public class DefaultContextAssociationManager
implements ContextAssociationManager,
Serializable {
    protected static final Logger log = Logger.getLogger(DefaultContextAssociationManager.class.getName());
    @Inject
    private BeanManager beanManager;

    protected Class<? extends ScopedAssociation> getBroadestActiveContext() {
        for (Class<? extends ScopedAssociation> scopeType : this.getAvailableScopedAssociationClasses()) {
            Annotation scopeAnnotation;
            Annotation annotation = scopeAnnotation = scopeType.getAnnotations().length > 0 ? scopeType.getAnnotations()[0] : null;
            if (scopeAnnotation == null || !this.beanManager.isScope(scopeAnnotation.annotationType())) {
                throw new ProcessEngineException("ScopedAssociation must carry exactly one annotation and it must be a @Scope annotation");
            }
            try {
                this.beanManager.getContext(scopeAnnotation.annotationType());
                return scopeType;
            }
            catch (ContextNotActiveException e) {
                log.finest("Context " + String.valueOf(scopeAnnotation.annotationType()) + " not active.");
            }
        }
        throw new ProcessEngineException("Could not determine an active context to associate the current process instance / task instance with.");
    }

    protected List<Class<? extends ScopedAssociation>> getAvailableScopedAssociationClasses() {
        ArrayList<Class<? extends ScopedAssociation>> scopeTypes = new ArrayList<Class<? extends ScopedAssociation>>();
        scopeTypes.add(ConversationScopedAssociation.class);
        scopeTypes.add(RequestScopedAssociation.class);
        return scopeTypes;
    }

    protected ScopedAssociation getScopedAssociation() {
        return ProgrammaticBeanLookup.lookup(this.getBroadestActiveContext(), this.beanManager);
    }

    @Override
    public void setExecution(Execution execution) {
        if (execution == null) {
            throw new ProcessEngineCdiException("Cannot associate with execution: null");
        }
        this.ensureCommandContextNotActive();
        ScopedAssociation scopedAssociation = this.getScopedAssociation();
        Execution associatedExecution = scopedAssociation.getExecution();
        if (associatedExecution != null && !associatedExecution.getId().equals(execution.getId())) {
            throw new ProcessEngineCdiException("Cannot associate " + String.valueOf(execution) + ", already associated with " + String.valueOf(associatedExecution) + ". Disassociate first!");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Associating " + String.valueOf(execution) + " (@" + scopedAssociation.getClass().getAnnotations()[0].annotationType().getSimpleName() + ")");
        }
        scopedAssociation.setExecution(execution);
    }

    @Override
    public void disAssociate() {
        this.ensureCommandContextNotActive();
        ScopedAssociation scopedAssociation = this.getScopedAssociation();
        if (scopedAssociation.getExecution() == null) {
            throw new ProcessEngineException("Cannot dissasociate execution, no " + scopedAssociation.getClass().getAnnotations()[0].annotationType().getSimpleName() + " execution associated. ");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Disassociating");
        }
        scopedAssociation.setExecution(null);
        scopedAssociation.setTask(null);
    }

    @Override
    public String getExecutionId() {
        Execution execution = this.getExecution();
        if (execution != null) {
            return execution.getId();
        }
        return null;
    }

    @Override
    public Execution getExecution() {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            return execution;
        }
        return this.getScopedAssociation().getExecution();
    }

    @Override
    public TypedValue getVariable(String variableName) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            return execution.getVariableTyped(variableName);
        }
        return this.getScopedAssociation().getVariable(variableName);
    }

    @Override
    public void setVariable(String variableName, Object value) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            execution.setVariable(variableName, value);
            execution.getVariable(variableName);
        } else {
            this.getScopedAssociation().setVariable(variableName, value);
        }
    }

    @Override
    public TypedValue getVariableLocal(String variableName) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            return execution.getVariableLocalTyped(variableName);
        }
        return this.getScopedAssociation().getVariableLocal(variableName);
    }

    @Override
    public void setVariableLocal(String variableName, Object value) {
        ExecutionEntity execution = this.getExecutionFromContext();
        if (execution != null) {
            execution.setVariableLocal(variableName, value);
            execution.getVariableLocal(variableName);
        } else {
            this.getScopedAssociation().setVariableLocal(variableName, value);
        }
    }

    protected ExecutionEntity getExecutionFromContext() {
        BpmnExecutionContext executionContext;
        if (Context.getCommandContext() != null && (executionContext = Context.getBpmnExecutionContext()) != null) {
            return (ExecutionEntity)executionContext.getExecution();
        }
        return null;
    }

    @Override
    public Task getTask() {
        this.ensureCommandContextNotActive();
        return this.getScopedAssociation().getTask();
    }

    @Override
    public void setTask(Task task) {
        this.ensureCommandContextNotActive();
        this.getScopedAssociation().setTask(task);
    }

    @Override
    public VariableMap getCachedVariables() {
        this.ensureCommandContextNotActive();
        return this.getScopedAssociation().getCachedVariables();
    }

    @Override
    public VariableMap getCachedLocalVariables() {
        this.ensureCommandContextNotActive();
        return this.getScopedAssociation().getCachedVariablesLocal();
    }

    @Override
    public void flushVariableCache() {
        this.ensureCommandContextNotActive();
        this.getScopedAssociation().flushVariableCache();
    }

    protected void ensureCommandContextNotActive() {
        if (Context.getCommandContext() != null) {
            throw new ProcessEngineCdiException("Cannot work with scoped associations inside command context.");
        }
    }
}

