/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.cdi.test.api;

import org.eximeebpms.bpm.engine.cdi.BusinessProcess;
import org.eximeebpms.bpm.engine.cdi.test.CdiProcessEngineTestCase;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ProcessVariableMapTest
extends CdiProcessEngineTestCase {
    private static final String VARNAME_1 = "aVariable";
    private static final String VARNAME_2 = "anotherVariable";

    @Test
    public void testProcessVariableMap() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        VariableMap variables = (VariableMap)this.getBeanInstance("processVariableMap");
        Assert.assertNotNull((Object)variables);
        String aValue = "aValue";
        businessProcess.setVariable(VARNAME_1, (Object)Variables.stringValue((String)aValue));
        Assert.assertEquals((Object)aValue, (Object)variables.get((Object)VARNAME_1));
        TypedValue aTypedValue = variables.getValueTyped(VARNAME_1);
        Assert.assertEquals((Object)ValueType.STRING, (Object)aTypedValue.getType());
        Assert.assertEquals((Object)aValue, (Object)aTypedValue.getValue());
        Assert.assertEquals((Object)aValue, (Object)variables.getValue(VARNAME_1, String.class));
        try {
            variables.getValue(VARNAME_1, Integer.class);
            Assert.fail((String)"ClassCastException expected!");
        }
        catch (ClassCastException ex) {
            Assert.assertEquals((Object)"Cannot cast variable named 'aVariable' with value 'aValue' to type 'class java.lang.Integer'.", (Object)ex.getMessage());
        }
        String anotherValue = "anotherValue";
        variables.put((Object)VARNAME_2, (Object)Variables.stringValue((String)anotherValue));
        Assert.assertEquals((Object)anotherValue, (Object)businessProcess.getVariable(VARNAME_2));
        TypedValue anotherTypedValue = businessProcess.getVariableTyped(VARNAME_2);
        Assert.assertEquals((Object)ValueType.STRING, (Object)anotherTypedValue.getType());
        Assert.assertEquals((Object)anotherValue, (Object)anotherTypedValue.getValue());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/cdi/test/api/BusinessProcessBeanTest.test.bpmn20.xml"})
    public void testProcessVariableMapLocal() {
        BusinessProcess businessProcess = this.getBeanInstance(BusinessProcess.class);
        businessProcess.startProcessByKey("businessProcessBeanTest");
        VariableMap variables = (VariableMap)this.getBeanInstance("processVariableMapLocal");
        Assert.assertNotNull((Object)variables);
        String aValue = "aValue";
        businessProcess.setVariableLocal(VARNAME_1, (Object)Variables.stringValue((String)aValue));
        Assert.assertEquals((Object)aValue, (Object)variables.get((Object)VARNAME_1));
        TypedValue aTypedValue = variables.getValueTyped(VARNAME_1);
        Assert.assertEquals((Object)ValueType.STRING, (Object)aTypedValue.getType());
        Assert.assertEquals((Object)aValue, (Object)aTypedValue.getValue());
        Assert.assertEquals((Object)aValue, (Object)variables.getValue(VARNAME_1, String.class));
        try {
            variables.getValue(VARNAME_1, Integer.class);
            Assert.fail((String)"ClassCastException expected!");
        }
        catch (ClassCastException ex) {
            Assert.assertEquals((Object)"Cannot cast variable named 'aVariable' with value 'aValue' to type 'class java.lang.Integer'.", (Object)ex.getMessage());
        }
        String anotherValue = "anotherValue";
        variables.put((Object)VARNAME_2, (Object)Variables.stringValue((String)anotherValue));
        Assert.assertEquals((Object)anotherValue, (Object)businessProcess.getVariableLocal(VARNAME_2));
        TypedValue anotherTypedValue = businessProcess.getVariableLocalTyped(VARNAME_2);
        Assert.assertEquals((Object)ValueType.STRING, (Object)anotherTypedValue.getType());
        Assert.assertEquals((Object)anotherValue, (Object)anotherTypedValue.getValue());
    }
}

