/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.cdi.test.impl.util;

import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Named;
import org.eximeebpms.bpm.engine.cdi.impl.ProcessEngineServicesProducer;
import org.eximeebpms.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;
import org.eximeebpms.bpm.engine.cdi.test.impl.beans.SpecializedTestBean;
import org.eximeebpms.bpm.engine.cdi.test.impl.util.BeanWithProducerMethods;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ProgrammaticBeanLookupTest {
    @ArquillianResource
    private Deployer deployer;

    @Deployment(name="normal", managed=false)
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(ProgrammaticBeanLookup.class)).addClass(ProcessEngineServicesProducer.class)).addAsManifestResource("org/eximeebpms/bpm/engine/cdi/test/impl/util/beans.xml", "beans.xml");
    }

    @Deployment(name="withAlternative", managed=false)
    public static JavaArchive createDeploymentWithAlternative() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(ProgrammaticBeanLookup.class)).addClass(ProcessEngineServicesProducer.class)).addClass(AlternativeTestBean.class)).addAsManifestResource("org/eximeebpms/bpm/engine/cdi/test/impl/util/beansWithAlternative.xml", "beans.xml");
    }

    @Deployment(name="withSpecialization", managed=false)
    public static JavaArchive createDeploymentWithSpecialization() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(ProgrammaticBeanLookup.class)).addClass(ProcessEngineServicesProducer.class)).addClass(SpecializedTestBean.class)).addAsManifestResource("org/eximeebpms/bpm/engine/cdi/test/impl/util/beans.xml", "beans.xml");
    }

    @Deployment(name="withProducerMethod", managed=false)
    public static JavaArchive createDeploymentWithProducerMethod() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(ProgrammaticBeanLookup.class)).addClass(ProcessEngineServicesProducer.class)).addClass(BeanWithProducerMethods.class)).addAsManifestResource("org/eximeebpms/bpm/engine/cdi/test/impl/util/beans.xml", "beans.xml");
    }

    @Test
    public void testLookupBean() {
        this.deployer.deploy("normal");
        Object lookup = ProgrammaticBeanLookup.lookup((String)"testOnly");
        Assert.assertThat((Object)lookup, (Matcher)IsInstanceOf.instanceOf(TestBean.class));
        this.deployer.undeploy("normal");
    }

    @Test
    public void testLookupShouldFindAlternative() {
        this.deployer.deploy("withAlternative");
        Object lookup = ProgrammaticBeanLookup.lookup((String)"testOnly");
        Assert.assertThat((Object)lookup.getClass().getName(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)AlternativeTestBean.class.getName())));
        this.deployer.undeploy("withAlternative");
    }

    @Test
    public void testLookupShouldFindSpecialization() {
        this.deployer.deploy("withSpecialization");
        Object lookup = ProgrammaticBeanLookup.lookup((String)"testOnly");
        Assert.assertThat((Object)lookup.getClass().getName(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)SpecializedTestBean.class.getName())));
        this.deployer.undeploy("withSpecialization");
    }

    @Test
    public void testLookupShouldSupportProducerMethods() {
        this.deployer.deploy("withProducerMethod");
        Assert.assertEquals((Object)"exampleString", (Object)ProgrammaticBeanLookup.lookup((String)"producedString"));
        this.deployer.undeploy("withProducerMethod");
    }

    @Alternative
    @Named(value="testOnly")
    public static class AlternativeTestBean
    extends TestBean {
    }

    @Named(value="testOnly")
    public static class TestBean {
    }
}

