/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.cdi.impl;

import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eximeebpms.bpm.BpmPlatform;
import org.eximeebpms.bpm.ProcessEngineService;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.ExternalTaskService;
import org.eximeebpms.bpm.engine.FilterService;
import org.eximeebpms.bpm.engine.FormService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.cdi.annotation.ProcessEngineName;

public class NamedProcessEngineServicesProducer {
    @Produces
    @ProcessEngineName(value="")
    public ProcessEngine processEngine(InjectionPoint ip) {
        ProcessEngineName annotation = (ProcessEngineName)ip.getAnnotated().getAnnotation(ProcessEngineName.class);
        String processEngineName = annotation.value();
        if (processEngineName == null || processEngineName.length() == 0) {
            throw new ProcessEngineException("Cannot determine which process engine to inject: @ProcessEngineName must specify the name of a process engine.");
        }
        try {
            ProcessEngineService processEngineService = BpmPlatform.getProcessEngineService();
            return processEngineService.getProcessEngine(processEngineName);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Cannot find process engine named '" + processEngineName + "' specified using @ProcessEngineName: " + e.getMessage(), (Throwable)e);
        }
    }

    @Produces
    @ProcessEngineName(value="")
    public RuntimeService runtimeService(InjectionPoint ip) {
        return this.processEngine(ip).getRuntimeService();
    }

    @Produces
    @ProcessEngineName(value="")
    public TaskService taskService(InjectionPoint ip) {
        return this.processEngine(ip).getTaskService();
    }

    @Produces
    @ProcessEngineName(value="")
    public RepositoryService repositoryService(InjectionPoint ip) {
        return this.processEngine(ip).getRepositoryService();
    }

    @Produces
    @ProcessEngineName(value="")
    public FormService formService(InjectionPoint ip) {
        return this.processEngine(ip).getFormService();
    }

    @Produces
    @ProcessEngineName(value="")
    public HistoryService historyService(InjectionPoint ip) {
        return this.processEngine(ip).getHistoryService();
    }

    @Produces
    @ProcessEngineName(value="")
    public IdentityService identityService(InjectionPoint ip) {
        return this.processEngine(ip).getIdentityService();
    }

    @Produces
    @ProcessEngineName(value="")
    public ManagementService managementService(InjectionPoint ip) {
        return this.processEngine(ip).getManagementService();
    }

    @Produces
    @ProcessEngineName(value="")
    public AuthorizationService authorizationService(InjectionPoint ip) {
        return this.processEngine(ip).getAuthorizationService();
    }

    @Produces
    @ProcessEngineName(value="")
    public FilterService filterService(InjectionPoint ip) {
        return this.processEngine(ip).getFilterService();
    }

    @Produces
    @ProcessEngineName(value="")
    public ExternalTaskService externalTaskService(InjectionPoint ip) {
        return this.processEngine(ip).getExternalTaskService();
    }

    @Produces
    @ProcessEngineName(value="")
    public CaseService caseService(InjectionPoint ip) {
        return this.processEngine(ip).getCaseService();
    }

    @Produces
    @ProcessEngineName(value="")
    public DecisionService decisionService(InjectionPoint ip) {
        return this.processEngine(ip).getDecisionService();
    }
}

