/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.cdi.impl.context;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.eximeebpms.bpm.engine.cdi.BusinessProcess;
import org.eximeebpms.bpm.engine.cdi.annotation.BusinessProcessScoped;
import org.eximeebpms.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;

public class BusinessProcessContext
implements Context {
    static final Logger logger = Logger.getLogger(BusinessProcessContext.class.getName());
    protected BeanManager beanManager;

    public BusinessProcessContext() {
    }

    public BusinessProcessContext(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    protected BusinessProcess getBusinessProcess() {
        return ProgrammaticBeanLookup.lookup(BusinessProcess.class, this.getBeanManager());
    }

    public Class<? extends Annotation> getScope() {
        return BusinessProcessScoped.class;
    }

    public <T> T get(Contextual<T> contextual) {
        Bean bean = (Bean)contextual;
        String variableName = bean.getName();
        return this.get(variableName);
    }

    protected <T> T get(String variableName) {
        BusinessProcess businessProcess = this.getBusinessProcess();
        Object variable = businessProcess.getVariable(variableName);
        if (variable != null) {
            if (logger.isLoggable(Level.FINE)) {
                if (businessProcess.isAssociated()) {
                    logger.fine("Getting instance of bean '" + variableName + "' from Execution[" + businessProcess.getExecutionId() + "].");
                } else {
                    logger.fine("Getting instance of bean '" + variableName + "' from transient bean store");
                }
            }
            return variable;
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> arg1) {
        Bean bean = (Bean)contextual;
        String variableName = bean.getName();
        Object beanInstance = bean.create(arg1);
        return (T)this.get(variableName, beanInstance);
    }

    protected <T> T get(String variableName, T beanInstance) {
        BusinessProcess businessProcess = this.getBusinessProcess();
        Object variable = businessProcess.getVariable(variableName);
        if (variable != null) {
            if (logger.isLoggable(Level.FINE)) {
                if (businessProcess.isAssociated()) {
                    logger.fine("Getting instance of bean '" + variableName + "' from Execution[" + businessProcess.getExecutionId() + "].");
                } else {
                    logger.fine("Getting instance of bean '" + variableName + "' from transient bean store");
                }
            }
            return variable;
        }
        if (logger.isLoggable(Level.FINE)) {
            if (businessProcess.isAssociated()) {
                logger.fine("Creating instance of bean '" + variableName + "' in business process context representing Execution[" + businessProcess.getExecutionId() + "].");
            } else {
                logger.fine("Creating instance of bean '" + variableName + "' in transient bean store");
            }
        }
        businessProcess.setVariable(variableName, beanInstance);
        return beanInstance;
    }

    public boolean isActive() {
        return true;
    }

    protected BeanManager getBeanManager() {
        return this.beanManager;
    }
}

