/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.converter;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringToTypeConverter;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;

public abstract class JacksonAwareStringToTypeConverter<T>
implements StringToTypeConverter<T> {
    protected ObjectMapper objectMapper;

    @Override
    public abstract T convertQueryParameterToType(String var1);

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected T mapToType(String value, Class<T> typeClass) {
        try {
            return (T)this.objectMapper.readValue(value, typeClass);
        }
        catch (JsonParseException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), String.format("Cannot convert value %s to java type %s", value, typeClass.getName()));
        }
        catch (JsonMappingException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), String.format("Cannot convert value %s to java type %s", value, typeClass.getName()));
        }
        catch (IOException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, String.format("Cannot convert value %s to java type %s", value, typeClass.getName()));
        }
    }
}

