/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.repository.DeploymentQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.EximeeBPMSQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.DateConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringListConverter;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;

public class DeploymentQueryDto
extends AbstractQueryDto<DeploymentQuery> {
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_DEPLOYMENT_TIME_VALUE = "deploymentTime";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    private String id;
    private String name;
    private String nameLike;
    private String source;
    private Boolean withoutSource;
    private Date before;
    private Date after;
    private List<String> tenantIds;
    private Boolean withoutTenantId;
    private Boolean includeDeploymentsWithoutTenantId;

    public DeploymentQueryDto() {
    }

    public DeploymentQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @EximeeBPMSQueryParam(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @EximeeBPMSQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @EximeeBPMSQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @EximeeBPMSQueryParam(value="source")
    public void setSource(String source) {
        this.source = source;
    }

    @EximeeBPMSQueryParam(value="withoutSource", converter=BooleanConverter.class)
    public void setWithoutSource(Boolean withoutSource) {
        this.withoutSource = withoutSource;
    }

    @EximeeBPMSQueryParam(value="before", converter=DateConverter.class)
    public void setDeploymentBefore(Date deploymentBefore) {
        this.before = deploymentBefore;
    }

    @EximeeBPMSQueryParam(value="after", converter=DateConverter.class)
    public void setDeploymentAfter(Date deploymentAfter) {
        this.after = deploymentAfter;
    }

    @EximeeBPMSQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @EximeeBPMSQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @EximeeBPMSQueryParam(value="includeDeploymentsWithoutTenantId", converter=BooleanConverter.class)
    public void setIncludeDeploymentsWithoutTenantId(Boolean includeDeploymentsWithoutTenantId) {
        this.includeDeploymentsWithoutTenantId = includeDeploymentsWithoutTenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected DeploymentQuery createNewQuery(ProcessEngine engine) {
        return engine.getRepositoryService().createDeploymentQuery();
    }

    @Override
    protected void applyFilters(DeploymentQuery query) {
        if (this.withoutSource != null && this.withoutSource.booleanValue() && this.source != null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "The query parameters \"withoutSource\" and \"source\" cannot be used in combination.");
        }
        if (this.id != null) {
            query.deploymentId(this.id);
        }
        if (this.name != null) {
            query.deploymentName(this.name);
        }
        if (this.nameLike != null) {
            query.deploymentNameLike(this.nameLike);
        }
        if (Boolean.TRUE.equals(this.withoutSource)) {
            query.deploymentSource(null);
        }
        if (this.source != null) {
            query.deploymentSource(this.source);
        }
        if (this.before != null) {
            query.deploymentBefore(this.before);
        }
        if (this.after != null) {
            query.deploymentAfter(this.after);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.includeDeploymentsWithoutTenantId)) {
            query.includeDeploymentsWithoutTenantId();
        }
    }

    @Override
    protected void applySortBy(DeploymentQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_ID_VALUE)) {
            query.orderByDeploymentId();
        } else if (sortBy.equals(SORT_BY_NAME_VALUE)) {
            query.orderByDeploymentName();
        } else if (sortBy.equals(SORT_BY_DEPLOYMENT_TIME_VALUE)) {
            query.orderByDeploymentTime();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

