/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.task;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.QueryEntityRelationCondition;
import org.eximeebpms.bpm.engine.impl.QueryOrderingProperty;
import org.eximeebpms.bpm.engine.impl.TaskQueryImpl;
import org.eximeebpms.bpm.engine.impl.TaskQueryProperty;
import org.eximeebpms.bpm.engine.impl.TaskQueryVariableValue;
import org.eximeebpms.bpm.engine.impl.VariableInstanceQueryProperty;
import org.eximeebpms.bpm.engine.impl.VariableOrderProperty;
import org.eximeebpms.bpm.engine.impl.persistence.entity.SuspensionState;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.query.QueryProperty;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.EximeeBPMSQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.SortingDto;
import org.eximeebpms.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.eximeebpms.bpm.engine.rest.dto.VariableValueDto;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.DateConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.DelegationStateConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.IntegerConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringListConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.VariableListConverter;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.exception.RestException;
import org.eximeebpms.bpm.engine.task.DelegationState;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.variable.type.ValueType;
import org.eximeebpms.bpm.engine.variable.type.ValueTypeResolver;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskQueryDto
extends AbstractQueryDto<TaskQuery> {
    public static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    public static final String SORT_BY_CASE_INSTANCE_ID_VALUE = "caseInstanceId";
    public static final String SORT_BY_DUE_DATE_VALUE = "dueDate";
    public static final String SORT_BY_FOLLOW_UP_VALUE = "followUpDate";
    public static final String SORT_BY_EXECUTION_ID_VALUE = "executionId";
    public static final String SORT_BY_CASE_EXECUTION_ID_VALUE = "caseExecutionId";
    public static final String SORT_BY_ASSIGNEE_VALUE = "assignee";
    public static final String SORT_BY_CREATE_TIME_VALUE = "created";
    public static final String SORT_BY_LAST_UPDATED_VALUE = "lastUpdated";
    public static final String SORT_BY_DESCRIPTION_VALUE = "description";
    public static final String SORT_BY_ID_VALUE = "id";
    public static final String SORT_BY_NAME_VALUE = "name";
    public static final String SORT_BY_NAME_CASE_INSENSITIVE_VALUE = "nameCaseInsensitive";
    public static final String SORT_BY_PRIORITY_VALUE = "priority";
    public static final String SORT_BY_TENANT_ID_VALUE = "tenantId";
    public static final String SORT_BY_PROCESS_VARIABLE = "processVariable";
    public static final String SORT_BY_EXECUTION_VARIABLE = "executionVariable";
    public static final String SORT_BY_TASK_VARIABLE = "taskVariable";
    public static final String SORT_BY_CASE_INSTANCE_VARIABLE = "caseInstanceVariable";
    public static final String SORT_BY_CASE_EXECUTION_VARIABLE = "caseExecutionVariable";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    public static final String SORT_PARAMETERS_VARIABLE_NAME = "variable";
    public static final String SORT_PARAMETERS_VALUE_TYPE = "type";
    private String processInstanceBusinessKey;
    private String processInstanceBusinessKeyExpression;
    private String[] processInstanceBusinessKeyIn;
    private String processInstanceBusinessKeyLike;
    private String processInstanceBusinessKeyLikeExpression;
    private String processDefinitionKey;
    private String[] processDefinitionKeyIn;
    private String processDefinitionId;
    private String executionId;
    private String[] activityInstanceIdIn;
    private String processDefinitionName;
    private String processDefinitionNameLike;
    private String processInstanceId;
    private String[] processInstanceIdIn;
    private String assignee;
    private String assigneeExpression;
    private String assigneeLike;
    private String assigneeLikeExpression;
    private String[] assigneeIn;
    private String[] assigneeNotIn;
    private String candidateGroup;
    private String candidateGroupExpression;
    private String candidateGroupLike;
    private String candidateUser;
    private String candidateUserExpression;
    private Boolean includeAssignedTasks;
    private String taskDefinitionKey;
    private String[] taskDefinitionKeyIn;
    private String[] taskDefinitionKeyNotIn;
    private String taskDefinitionKeyLike;
    private String taskId;
    private String[] taskIdIn;
    private String description;
    private String descriptionLike;
    private String involvedUser;
    private String involvedUserExpression;
    private Integer maxPriority;
    private Integer minPriority;
    private String name;
    private String nameNotEqual;
    private String nameLike;
    private String nameNotLike;
    private String owner;
    private String ownerExpression;
    private Integer priority;
    private String parentTaskId;
    protected Boolean assigned;
    private Boolean unassigned;
    private Boolean active;
    private Boolean suspended;
    private String caseDefinitionKey;
    private String caseDefinitionId;
    private String caseDefinitionName;
    private String caseDefinitionNameLike;
    private String caseInstanceId;
    private String caseInstanceBusinessKey;
    private String caseInstanceBusinessKeyLike;
    private String caseExecutionId;
    private Date dueAfter;
    private String dueAfterExpression;
    private Date dueBefore;
    private String dueBeforeExpression;
    private Date dueDate;
    private String dueDateExpression;
    private Boolean withoutDueDate;
    private Date followUpAfter;
    private String followUpAfterExpression;
    private Date followUpBefore;
    private String followUpBeforeExpression;
    private Date followUpBeforeOrNotExistent;
    private String followUpBeforeOrNotExistentExpression;
    private Date followUpDate;
    private String followUpDateExpression;
    private Date createdAfter;
    private String createdAfterExpression;
    private Date createdBefore;
    private String createdBeforeExpression;
    private Date createdOn;
    private String createdOnExpression;
    private Date updatedAfter;
    private String updatedAfterExpression;
    private String delegationState;
    private String[] tenantIdIn;
    private Boolean withoutTenantId;
    private List<String> candidateGroups;
    private String candidateGroupsExpression;
    protected Boolean withCandidateGroups;
    protected Boolean withoutCandidateGroups;
    protected Boolean withCandidateUsers;
    protected Boolean withoutCandidateUsers;
    protected Boolean variableNamesIgnoreCase;
    protected Boolean variableValuesIgnoreCase;
    private List<VariableQueryParameterDto> taskVariables;
    private List<VariableQueryParameterDto> processVariables;
    private List<VariableQueryParameterDto> caseInstanceVariables;
    private List<TaskQueryDto> orQueries;
    private Boolean withCommentAttachmentInfo;
    private Boolean withTaskVariablesInReturn;
    private Boolean withTaskLocalVariablesInReturn;

    public TaskQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @EximeeBPMSQueryParam(value="orQueries")
    public void setOrQueries(List<TaskQueryDto> orQueries) {
        this.orQueries = orQueries;
    }

    @EximeeBPMSQueryParam(value="processInstanceBusinessKey")
    public void setProcessInstanceBusinessKey(String businessKey) {
        this.processInstanceBusinessKey = businessKey;
    }

    @EximeeBPMSQueryParam(value="processInstanceBusinessKeyExpression")
    public void setProcessInstanceBusinessKeyExpression(String businessKeyExpression) {
        this.processInstanceBusinessKeyExpression = businessKeyExpression;
    }

    @EximeeBPMSQueryParam(value="processInstanceBusinessKeyIn", converter=StringArrayConverter.class)
    public void setProcessInstanceBusinessKeyIn(String[] processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
    }

    @EximeeBPMSQueryParam(value="processInstanceBusinessKeyLike")
    public void setProcessInstanceBusinessKeyLike(String businessKeyLike) {
        this.processInstanceBusinessKeyLike = businessKeyLike;
    }

    @EximeeBPMSQueryParam(value="processInstanceBusinessKeyLikeExpression")
    public void setProcessInstanceBusinessKeyLikeExpression(String businessKeyLikeExpression) {
        this.processInstanceBusinessKeyLikeExpression = businessKeyLikeExpression;
    }

    @EximeeBPMSQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @EximeeBPMSQueryParam(value="processDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionKeyIn(String[] processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    @EximeeBPMSQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @EximeeBPMSQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @EximeeBPMSQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @EximeeBPMSQueryParam(value="tenantIdIn", converter=StringArrayConverter.class)
    public void setTenantIdIn(String[] tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    @EximeeBPMSQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @EximeeBPMSQueryParam(value="processDefinitionName")
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @EximeeBPMSQueryParam(value="processDefinitionNameLike")
    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    @EximeeBPMSQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @EximeeBPMSQueryParam(value="processInstanceIdIn", converter=StringArrayConverter.class)
    public void setProcessInstanceIdIn(String[] processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    @EximeeBPMSQueryParam(value="assignee")
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @EximeeBPMSQueryParam(value="assigneeExpression")
    public void setAssigneeExpression(String assigneeExpression) {
        this.assigneeExpression = assigneeExpression;
    }

    @EximeeBPMSQueryParam(value="assigneeLike")
    public void setAssigneeLike(String assigneeLike) {
        this.assigneeLike = assigneeLike;
    }

    @EximeeBPMSQueryParam(value="assigneeIn", converter=StringArrayConverter.class)
    public void setAssigneeIn(String[] assigneeIn) {
        this.assigneeIn = assigneeIn;
    }

    @EximeeBPMSQueryParam(value="assigneeNotIn", converter=StringArrayConverter.class)
    public void setAssigneeNotIn(String[] assigneeNotIn) {
        this.assigneeNotIn = assigneeNotIn;
    }

    @EximeeBPMSQueryParam(value="assigneeLikeExpression")
    public void setAssigneeLikeExpression(String assigneeLikeExpression) {
        this.assigneeLikeExpression = assigneeLikeExpression;
    }

    @EximeeBPMSQueryParam(value="candidateGroup")
    public void setCandidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
    }

    @EximeeBPMSQueryParam(value="candidateGroupExpression")
    public void setCandidateGroupExpression(String candidateGroupExpression) {
        this.candidateGroupExpression = candidateGroupExpression;
    }

    @EximeeBPMSQueryParam(value="candidateGroupLike")
    public void setCandidateGroupLike(String candidateGroupLike) {
        this.candidateGroupLike = candidateGroupLike;
    }

    @EximeeBPMSQueryParam(value="withCandidateGroups", converter=BooleanConverter.class)
    public void setWithCandidateGroups(Boolean withCandidateGroups) {
        this.withCandidateGroups = withCandidateGroups;
    }

    @EximeeBPMSQueryParam(value="withoutCandidateGroups", converter=BooleanConverter.class)
    public void setWithoutCandidateGroups(Boolean withoutCandidateGroups) {
        this.withoutCandidateGroups = withoutCandidateGroups;
    }

    @EximeeBPMSQueryParam(value="withCandidateUsers", converter=BooleanConverter.class)
    public void setWithCandidateUsers(Boolean withCandidateUsers) {
        this.withCandidateUsers = withCandidateUsers;
    }

    @EximeeBPMSQueryParam(value="withoutCandidateUsers", converter=BooleanConverter.class)
    public void setWithoutCandidateUsers(Boolean withoutCandidateUsers) {
        this.withoutCandidateUsers = withoutCandidateUsers;
    }

    @EximeeBPMSQueryParam(value="candidateUser")
    public void setCandidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
    }

    @EximeeBPMSQueryParam(value="candidateUserExpression")
    public void setCandidateUserExpression(String candidateUserExpression) {
        this.candidateUserExpression = candidateUserExpression;
    }

    @EximeeBPMSQueryParam(value="includeAssignedTasks", converter=BooleanConverter.class)
    public void setIncludeAssignedTasks(Boolean includeAssignedTasks) {
        this.includeAssignedTasks = includeAssignedTasks;
    }

    @EximeeBPMSQueryParam(value="taskId")
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @EximeeBPMSQueryParam(value="taskIdIn", converter=StringArrayConverter.class)
    public void setTaskIdIn(String[] taskIdIn) {
        this.taskIdIn = taskIdIn;
    }

    @EximeeBPMSQueryParam(value="taskDefinitionKey")
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @EximeeBPMSQueryParam(value="taskDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setTaskDefinitionKeyIn(String[] taskDefinitionKeyIn) {
        this.taskDefinitionKeyIn = taskDefinitionKeyIn;
    }

    @EximeeBPMSQueryParam(value="taskDefinitionKeyNotIn", converter=StringArrayConverter.class)
    public void setTaskDefinitionKeyNotIn(String[] taskDefinitionKeyNotIn) {
        this.taskDefinitionKeyNotIn = taskDefinitionKeyNotIn;
    }

    @EximeeBPMSQueryParam(value="taskDefinitionKeyLike")
    public void setTaskDefinitionKeyLike(String taskDefinitionKeyLike) {
        this.taskDefinitionKeyLike = taskDefinitionKeyLike;
    }

    @EximeeBPMSQueryParam(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @EximeeBPMSQueryParam(value="descriptionLike")
    public void setDescriptionLike(String descriptionLike) {
        this.descriptionLike = descriptionLike;
    }

    @EximeeBPMSQueryParam(value="involvedUser")
    public void setInvolvedUser(String involvedUser) {
        this.involvedUser = involvedUser;
    }

    @EximeeBPMSQueryParam(value="involvedUserExpression")
    public void setInvolvedUserExpression(String involvedUserExpression) {
        this.involvedUserExpression = involvedUserExpression;
    }

    @EximeeBPMSQueryParam(value="maxPriority", converter=IntegerConverter.class)
    public void setMaxPriority(Integer maxPriority) {
        this.maxPriority = maxPriority;
    }

    @EximeeBPMSQueryParam(value="minPriority", converter=IntegerConverter.class)
    public void setMinPriority(Integer minPriority) {
        this.minPriority = minPriority;
    }

    @EximeeBPMSQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @EximeeBPMSQueryParam(value="nameNotEqual")
    public void setNameNotEqual(String nameNotEqual) {
        this.nameNotEqual = nameNotEqual;
    }

    @EximeeBPMSQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @EximeeBPMSQueryParam(value="nameNotLike")
    public void setNameNotLike(String nameNotLike) {
        this.nameNotLike = nameNotLike;
    }

    @EximeeBPMSQueryParam(value="owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @EximeeBPMSQueryParam(value="ownerExpression")
    public void setOwnerExpression(String ownerExpression) {
        this.ownerExpression = ownerExpression;
    }

    @EximeeBPMSQueryParam(value="priority", converter=IntegerConverter.class)
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @EximeeBPMSQueryParam(value="parentTaskId")
    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    @EximeeBPMSQueryParam(value="assigned", converter=BooleanConverter.class)
    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    @EximeeBPMSQueryParam(value="unassigned", converter=BooleanConverter.class)
    public void setUnassigned(Boolean unassigned) {
        this.unassigned = unassigned;
    }

    @EximeeBPMSQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @EximeeBPMSQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @EximeeBPMSQueryParam(value="dueAfter", converter=DateConverter.class)
    public void setDueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
    }

    @EximeeBPMSQueryParam(value="dueAfterExpression")
    public void setDueAfterExpression(String dueAfterExpression) {
        this.dueAfterExpression = dueAfterExpression;
    }

    @EximeeBPMSQueryParam(value="dueBefore", converter=DateConverter.class)
    public void setDueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
    }

    @EximeeBPMSQueryParam(value="dueBeforeExpression")
    public void setDueBeforeExpression(String dueBeforeExpression) {
        this.dueBeforeExpression = dueBeforeExpression;
    }

    @EximeeBPMSQueryParam(value="dueDate", converter=DateConverter.class)
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Deprecated
    @EximeeBPMSQueryParam(value="due", converter=DateConverter.class)
    public void setDue(Date dueDate) {
        this.dueDate = dueDate;
    }

    @EximeeBPMSQueryParam(value="dueDateExpression")
    public void setDueDateExpression(String dueDateExpression) {
        this.dueDateExpression = dueDateExpression;
    }

    @EximeeBPMSQueryParam(value="withoutDueDate", converter=BooleanConverter.class)
    public void setWithoutDueDate(Boolean withoutDueDate) {
        this.withoutDueDate = withoutDueDate;
    }

    @EximeeBPMSQueryParam(value="followUpAfter", converter=DateConverter.class)
    public void setFollowUpAfter(Date followUpAfter) {
        this.followUpAfter = followUpAfter;
    }

    @EximeeBPMSQueryParam(value="followUpAfterExpression")
    public void setFollowUpAfterExpression(String followUpAfterExpression) {
        this.followUpAfterExpression = followUpAfterExpression;
    }

    @EximeeBPMSQueryParam(value="followUpBefore", converter=DateConverter.class)
    public void setFollowUpBefore(Date followUpBefore) {
        this.followUpBefore = followUpBefore;
    }

    @EximeeBPMSQueryParam(value="followUpBeforeOrNotExistentExpression")
    public void setFollowUpBeforeOrNotExistentExpression(String followUpBeforeExpression) {
        this.followUpBeforeOrNotExistentExpression = followUpBeforeExpression;
    }

    @EximeeBPMSQueryParam(value="followUpBeforeOrNotExistent", converter=DateConverter.class)
    public void setFollowUpBeforeOrNotExistent(Date followUpBefore) {
        this.followUpBeforeOrNotExistent = followUpBefore;
    }

    @EximeeBPMSQueryParam(value="followUpBeforeExpression")
    public void setFollowUpBeforeExpression(String followUpBeforeExpression) {
        this.followUpBeforeExpression = followUpBeforeExpression;
    }

    @EximeeBPMSQueryParam(value="followUpDate", converter=DateConverter.class)
    public void setFollowUpDate(Date followUpDate) {
        this.followUpDate = followUpDate;
    }

    @Deprecated
    @EximeeBPMSQueryParam(value="followUp", converter=DateConverter.class)
    public void setFollowUp(Date followUpDate) {
        this.followUpDate = followUpDate;
    }

    @EximeeBPMSQueryParam(value="followUpDateExpression")
    public void setFollowUpDateExpression(String followUpDateExpression) {
        this.followUpDateExpression = followUpDateExpression;
    }

    @EximeeBPMSQueryParam(value="createdAfter", converter=DateConverter.class)
    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    @EximeeBPMSQueryParam(value="createdAfterExpression")
    public void setCreatedAfterExpression(String createdAfterExpression) {
        this.createdAfterExpression = createdAfterExpression;
    }

    @EximeeBPMSQueryParam(value="createdBefore", converter=DateConverter.class)
    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    @EximeeBPMSQueryParam(value="createdBeforeExpression")
    public void setCreatedBeforeExpression(String createdBeforeExpression) {
        this.createdBeforeExpression = createdBeforeExpression;
    }

    @EximeeBPMSQueryParam(value="createdOn", converter=DateConverter.class)
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @Deprecated
    @EximeeBPMSQueryParam(value="created", converter=DateConverter.class)
    public void setCreated(Date createdOn) {
        this.createdOn = createdOn;
    }

    @EximeeBPMSQueryParam(value="createdOnExpression")
    public void setCreatedOnExpression(String createdOnExpression) {
        this.createdOnExpression = createdOnExpression;
    }

    @EximeeBPMSQueryParam(value="updatedAfter", converter=DateConverter.class)
    public void setUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
    }

    @EximeeBPMSQueryParam(value="updatedAfterExpression")
    public void setUpdatedAfterExpression(String updatedAfterExpression) {
        this.updatedAfterExpression = updatedAfterExpression;
    }

    @EximeeBPMSQueryParam(value="delegationState")
    public void setDelegationState(String taskDelegationState) {
        this.delegationState = taskDelegationState;
    }

    @EximeeBPMSQueryParam(value="candidateGroups", converter=StringListConverter.class)
    public void setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }

    @EximeeBPMSQueryParam(value="candidateGroupsExpression")
    public void setCandidateGroupsExpression(String candidateGroupsExpression) {
        this.candidateGroupsExpression = candidateGroupsExpression;
    }

    @EximeeBPMSQueryParam(value="taskVariables", converter=VariableListConverter.class)
    public void setTaskVariables(List<VariableQueryParameterDto> taskVariables) {
        this.taskVariables = taskVariables;
    }

    @EximeeBPMSQueryParam(value="processVariables", converter=VariableListConverter.class)
    public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
    }

    @EximeeBPMSQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @EximeeBPMSQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @EximeeBPMSQueryParam(value="caseDefinitionName")
    public void setCaseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
    }

    @EximeeBPMSQueryParam(value="caseDefinitionNameLike")
    public void setCaseDefinitionNameLike(String caseDefinitionNameLike) {
        this.caseDefinitionNameLike = caseDefinitionNameLike;
    }

    @EximeeBPMSQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @EximeeBPMSQueryParam(value="caseInstanceBusinessKey")
    public void setCaseInstanceBusinessKey(String caseInstanceBusinessKey) {
        this.caseInstanceBusinessKey = caseInstanceBusinessKey;
    }

    @EximeeBPMSQueryParam(value="caseInstanceBusinessKeyLike")
    public void setCaseInstanceBusinessKeyLike(String caseInstanceBusinessKeyLike) {
        this.caseInstanceBusinessKeyLike = caseInstanceBusinessKeyLike;
    }

    @EximeeBPMSQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @EximeeBPMSQueryParam(value="caseInstanceVariables", converter=VariableListConverter.class)
    public void setCaseInstanceVariables(List<VariableQueryParameterDto> caseInstanceVariables) {
        this.caseInstanceVariables = caseInstanceVariables;
    }

    @EximeeBPMSQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesCaseInsensitive) {
        this.variableNamesIgnoreCase = variableNamesCaseInsensitive;
    }

    @EximeeBPMSQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesCaseInsensitive) {
        this.variableValuesIgnoreCase = variableValuesCaseInsensitive;
    }

    @EximeeBPMSQueryParam(value="withCommentAttachmentInfo", converter=BooleanConverter.class)
    public void setWithCommentAttachmentInfo(Boolean withCommentAttachmentInfo) {
        this.withCommentAttachmentInfo = withCommentAttachmentInfo;
    }

    @EximeeBPMSQueryParam(value="withTaskVariablesInReturn", converter=BooleanConverter.class)
    public void setWithTaskVariablesInReturn(Boolean withTaskVariablesInReturn) {
        this.withTaskVariablesInReturn = withTaskVariablesInReturn;
    }

    @EximeeBPMSQueryParam(value="withTaskLocalVariablesInReturn", converter=BooleanConverter.class)
    public void setWithTaskLocalVariablesInReturn(Boolean withTaskLocalVariablesInReturn) {
        this.withTaskLocalVariablesInReturn = withTaskLocalVariablesInReturn;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected TaskQuery createNewQuery(ProcessEngine engine) {
        return engine.getTaskService().createTaskQuery();
    }

    @Override
    protected void applyFilters(TaskQuery query) {
        Object variableValue;
        String op;
        String variableName;
        if (this.orQueries != null) {
            for (TaskQueryDto orQueryDto : this.orQueries) {
                TaskQueryImpl orQuery = new TaskQueryImpl();
                orQuery.setOrQueryActive();
                orQueryDto.applyFilters((TaskQuery)orQuery);
                ((TaskQueryImpl)query).addOrQuery(orQuery);
            }
        }
        if (this.processInstanceBusinessKey != null) {
            query.processInstanceBusinessKey(this.processInstanceBusinessKey);
        }
        if (this.processInstanceBusinessKeyExpression != null) {
            query.processInstanceBusinessKeyExpression(this.processInstanceBusinessKeyExpression);
        }
        if (this.processInstanceBusinessKeyIn != null && this.processInstanceBusinessKeyIn.length > 0) {
            query.processInstanceBusinessKeyIn(this.processInstanceBusinessKeyIn);
        }
        if (this.processInstanceBusinessKeyLike != null) {
            query.processInstanceBusinessKeyLike(this.processInstanceBusinessKeyLike);
        }
        if (this.processInstanceBusinessKeyLikeExpression != null) {
            query.processInstanceBusinessKeyLikeExpression(this.processInstanceBusinessKeyLikeExpression);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionKeyIn != null && this.processDefinitionKeyIn.length > 0) {
            query.processDefinitionKeyIn(this.processDefinitionKeyIn);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.activityInstanceIdIn != null && this.activityInstanceIdIn.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.tenantIdIn != null && this.tenantIdIn.length > 0) {
            query.tenantIdIn(this.tenantIdIn);
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.processDefinitionName != null) {
            query.processDefinitionName(this.processDefinitionName);
        }
        if (this.processDefinitionNameLike != null) {
            query.processDefinitionNameLike(this.processDefinitionNameLike);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processInstanceIdIn != null && this.processInstanceIdIn.length > 0) {
            query.processInstanceIdIn(this.processInstanceIdIn);
        }
        if (this.assignee != null) {
            query.taskAssignee(this.assignee);
        }
        if (this.assigneeExpression != null) {
            query.taskAssigneeExpression(this.assigneeExpression);
        }
        if (this.assigneeLike != null) {
            query.taskAssigneeLike(this.assigneeLike);
        }
        if (this.assigneeLikeExpression != null) {
            query.taskAssigneeLikeExpression(this.assigneeLikeExpression);
        }
        if (this.assigneeIn != null && this.assigneeIn.length > 0) {
            query.taskAssigneeIn(this.assigneeIn);
        }
        if (this.assigneeNotIn != null && this.assigneeNotIn.length > 0) {
            query.taskAssigneeNotIn(this.assigneeNotIn);
        }
        if (this.candidateGroup != null) {
            query.taskCandidateGroup(this.candidateGroup);
        }
        if (this.candidateGroupExpression != null) {
            query.taskCandidateGroupExpression(this.candidateGroupExpression);
        }
        if (this.candidateGroupLike != null) {
            query.taskCandidateGroupLike(this.candidateGroupLike);
        }
        if (this.withCandidateGroups != null && this.withCandidateGroups.booleanValue()) {
            query.withCandidateGroups();
        }
        if (this.withoutCandidateGroups != null && this.withoutCandidateGroups.booleanValue()) {
            query.withoutCandidateGroups();
        }
        if (this.withCandidateUsers != null && this.withCandidateUsers.booleanValue()) {
            query.withCandidateUsers();
        }
        if (this.withoutCandidateUsers != null && this.withoutCandidateUsers.booleanValue()) {
            query.withoutCandidateUsers();
        }
        if (this.candidateUser != null) {
            query.taskCandidateUser(this.candidateUser);
        }
        if (this.candidateUserExpression != null) {
            query.taskCandidateUserExpression(this.candidateUserExpression);
        }
        if (this.taskIdIn != null && this.taskIdIn.length > 0) {
            query.taskIdIn(this.taskIdIn);
        }
        if (this.taskId != null) {
            query.taskId(this.taskId);
        }
        if (this.taskDefinitionKeyIn != null && this.taskDefinitionKeyIn.length > 0) {
            query.taskDefinitionKeyIn(this.taskDefinitionKeyIn);
        }
        if (this.taskDefinitionKeyNotIn != null && this.taskDefinitionKeyNotIn.length > 0) {
            query.taskDefinitionKeyNotIn(this.taskDefinitionKeyNotIn);
        }
        if (this.taskDefinitionKey != null) {
            query.taskDefinitionKey(this.taskDefinitionKey);
        }
        if (this.taskDefinitionKeyLike != null) {
            query.taskDefinitionKeyLike(this.taskDefinitionKeyLike);
        }
        if (this.description != null) {
            query.taskDescription(this.description);
        }
        if (this.descriptionLike != null) {
            query.taskDescriptionLike(this.descriptionLike);
        }
        if (this.involvedUser != null) {
            query.taskInvolvedUser(this.involvedUser);
        }
        if (this.involvedUserExpression != null) {
            query.taskInvolvedUserExpression(this.involvedUserExpression);
        }
        if (this.maxPriority != null) {
            query.taskMaxPriority(this.maxPriority);
        }
        if (this.minPriority != null) {
            query.taskMinPriority(this.minPriority);
        }
        if (this.name != null) {
            query.taskName(this.name);
        }
        if (this.nameNotEqual != null) {
            query.taskNameNotEqual(this.nameNotEqual);
        }
        if (this.nameLike != null) {
            query.taskNameLike(this.nameLike);
        }
        if (this.nameNotLike != null) {
            query.taskNameNotLike(this.nameNotLike);
        }
        if (this.owner != null) {
            query.taskOwner(this.owner);
        }
        if (this.ownerExpression != null) {
            query.taskOwnerExpression(this.ownerExpression);
        }
        if (this.priority != null) {
            query.taskPriority(this.priority);
        }
        if (this.parentTaskId != null) {
            query.taskParentTaskId(this.parentTaskId);
        }
        if (this.assigned != null && this.assigned.booleanValue()) {
            query.taskAssigned();
        }
        if (this.unassigned != null && this.unassigned.booleanValue()) {
            query.taskUnassigned();
        }
        if (this.dueAfter != null) {
            query.dueAfter(this.dueAfter);
        }
        if (this.dueAfterExpression != null) {
            query.dueAfterExpression(this.dueAfterExpression);
        }
        if (this.dueBefore != null) {
            query.dueBefore(this.dueBefore);
        }
        if (this.dueBeforeExpression != null) {
            query.dueBeforeExpression(this.dueBeforeExpression);
        }
        if (this.dueDate != null) {
            query.dueDate(this.dueDate);
        }
        if (this.dueDateExpression != null) {
            query.dueDateExpression(this.dueDateExpression);
        }
        if (Boolean.TRUE.equals(this.withoutDueDate)) {
            query.withoutDueDate();
        }
        if (this.followUpAfter != null) {
            query.followUpAfter(this.followUpAfter);
        }
        if (this.followUpAfterExpression != null) {
            query.followUpAfterExpression(this.followUpAfterExpression);
        }
        if (this.followUpBefore != null) {
            query.followUpBefore(this.followUpBefore);
        }
        if (this.followUpBeforeExpression != null) {
            query.followUpBeforeExpression(this.followUpBeforeExpression);
        }
        if (this.followUpBeforeOrNotExistent != null) {
            query.followUpBeforeOrNotExistent(this.followUpBeforeOrNotExistent);
        }
        if (this.followUpBeforeOrNotExistentExpression != null) {
            query.followUpBeforeOrNotExistentExpression(this.followUpBeforeOrNotExistentExpression);
        }
        if (this.followUpDate != null) {
            query.followUpDate(this.followUpDate);
        }
        if (this.followUpDateExpression != null) {
            query.followUpDateExpression(this.followUpDateExpression);
        }
        if (this.createdAfter != null) {
            query.taskCreatedAfter(this.createdAfter);
        }
        if (this.createdAfterExpression != null) {
            query.taskCreatedAfterExpression(this.createdAfterExpression);
        }
        if (this.createdBefore != null) {
            query.taskCreatedBefore(this.createdBefore);
        }
        if (this.createdBeforeExpression != null) {
            query.taskCreatedBeforeExpression(this.createdBeforeExpression);
        }
        if (this.createdOn != null) {
            query.taskCreatedOn(this.createdOn);
        }
        if (this.createdOnExpression != null) {
            query.taskCreatedOnExpression(this.createdOnExpression);
        }
        if (this.updatedAfter != null) {
            query.taskUpdatedAfter(this.updatedAfter);
        }
        if (this.updatedAfterExpression != null) {
            query.taskUpdatedAfterExpression(this.updatedAfterExpression);
        }
        if (this.delegationState != null) {
            DelegationStateConverter converter = new DelegationStateConverter();
            DelegationState state = converter.convertQueryParameterToType(this.delegationState);
            query.taskDelegationState(state);
        }
        if (this.candidateGroups != null) {
            query.taskCandidateGroupIn(this.candidateGroups);
        }
        if (this.candidateGroupsExpression != null) {
            query.taskCandidateGroupInExpression(this.candidateGroupsExpression);
        }
        if (this.includeAssignedTasks != null && this.includeAssignedTasks.booleanValue()) {
            query.includeAssignedTasks();
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseDefinitionName != null) {
            query.caseDefinitionName(this.caseDefinitionName);
        }
        if (this.caseDefinitionNameLike != null) {
            query.caseDefinitionNameLike(this.caseDefinitionNameLike);
        }
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.caseInstanceBusinessKey != null) {
            query.caseInstanceBusinessKey(this.caseInstanceBusinessKey);
        }
        if (this.caseInstanceBusinessKeyLike != null) {
            query.caseInstanceBusinessKeyLike(this.caseInstanceBusinessKeyLike);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.variableValuesIgnoreCase != null && this.variableValuesIgnoreCase.booleanValue()) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.variableNamesIgnoreCase != null && this.variableNamesIgnoreCase.booleanValue()) {
            query.matchVariableNamesIgnoreCase();
        }
        if (this.taskVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.taskVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.taskVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.taskVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.taskVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.taskVariableValueGreaterThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.taskVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.taskVariableValueLessThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.taskVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid task variable comparator specified: " + op);
            }
        }
        if (this.processVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.processVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.processVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.processVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.processVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.processVariableValueGreaterThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.processVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.processVariableValueLessThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.processVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                if (op.equals("notLike")) {
                    query.processVariableValueNotLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid process variable comparator specified: " + op);
            }
        }
        if (this.caseInstanceVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.caseInstanceVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.caseInstanceVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.caseInstanceVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.caseInstanceVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.caseInstanceVariableValueGreaterThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.caseInstanceVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.caseInstanceVariableValueLessThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.caseInstanceVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid case variable comparator specified: " + op);
            }
        }
        if (this.withCommentAttachmentInfo != null && this.withCommentAttachmentInfo.booleanValue()) {
            query.withCommentAttachmentInfo();
        }
    }

    @Override
    protected void applySortBy(TaskQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_CASE_INSTANCE_ID_VALUE)) {
            query.orderByCaseInstanceId();
        } else if (sortBy.equals(SORT_BY_DUE_DATE_VALUE)) {
            query.orderByDueDate();
        } else if (sortBy.equals(SORT_BY_FOLLOW_UP_VALUE)) {
            query.orderByFollowUpDate();
        } else if (sortBy.equals(SORT_BY_EXECUTION_ID_VALUE)) {
            query.orderByExecutionId();
        } else if (sortBy.equals(SORT_BY_CASE_EXECUTION_ID_VALUE)) {
            query.orderByCaseExecutionId();
        } else if (sortBy.equals(SORT_BY_ASSIGNEE_VALUE)) {
            query.orderByTaskAssignee();
        } else if (sortBy.equals(SORT_BY_CREATE_TIME_VALUE)) {
            query.orderByTaskCreateTime();
        } else if (sortBy.equals(SORT_BY_LAST_UPDATED_VALUE)) {
            query.orderByLastUpdated();
        } else if (sortBy.equals(SORT_BY_DESCRIPTION_VALUE)) {
            query.orderByTaskDescription();
        } else if (sortBy.equals(SORT_BY_ID_VALUE)) {
            query.orderByTaskId();
        } else if (sortBy.equals(SORT_BY_NAME_VALUE)) {
            query.orderByTaskName();
        } else if (sortBy.equals(SORT_BY_TENANT_ID_VALUE)) {
            query.orderByTenantId();
        } else if (sortBy.equals(SORT_BY_NAME_CASE_INSENSITIVE_VALUE)) {
            query.orderByTaskNameCaseInsensitive();
        } else if (sortBy.equals(SORT_BY_PRIORITY_VALUE)) {
            query.orderByTaskPriority();
        } else if (sortBy.equals(SORT_BY_PROCESS_VARIABLE)) {
            String variableName = this.getVariableName(parameters);
            String valueTypeName = this.getValueTypeName(parameters);
            query.orderByProcessVariable(variableName, this.getValueTypeByName(valueTypeName, engine));
        } else if (sortBy.equals(SORT_BY_EXECUTION_VARIABLE)) {
            String variableName = this.getVariableName(parameters);
            String valueTypeName = this.getValueTypeName(parameters);
            query.orderByExecutionVariable(variableName, this.getValueTypeByName(valueTypeName, engine));
        } else if (sortBy.equals(SORT_BY_TASK_VARIABLE)) {
            String variableName = this.getVariableName(parameters);
            String valueTypeName = this.getValueTypeName(parameters);
            query.orderByTaskVariable(variableName, this.getValueTypeByName(valueTypeName, engine));
        } else if (sortBy.equals(SORT_BY_CASE_INSTANCE_VARIABLE)) {
            String variableName = this.getVariableName(parameters);
            String valueTypeName = this.getValueTypeName(parameters);
            query.orderByCaseInstanceVariable(variableName, this.getValueTypeByName(valueTypeName, engine));
        } else if (sortBy.equals(SORT_BY_CASE_EXECUTION_VARIABLE)) {
            String variableName = this.getVariableName(parameters);
            String valueTypeName = this.getValueTypeName(parameters);
            query.orderByCaseExecutionVariable(variableName, this.getValueTypeByName(valueTypeName, engine));
        }
    }

    protected String getValueTypeName(Map<String, Object> parameters) {
        String valueTypeName = (String)this.getValue(parameters, SORT_PARAMETERS_VALUE_TYPE);
        if (valueTypeName != null) {
            valueTypeName = VariableValueDto.fromRestApiTypeName(valueTypeName);
        }
        return valueTypeName;
    }

    protected String getVariableName(Map<String, Object> parameters) {
        return (String)this.getValue(parameters, SORT_PARAMETERS_VARIABLE_NAME);
    }

    protected Object getValue(Map<String, Object> map, String key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    protected ValueType getValueTypeByName(String name, ProcessEngine engine) {
        ValueTypeResolver valueTypeResolver = engine.getProcessEngineConfiguration().getValueTypeResolver();
        return valueTypeResolver.typeForName(name);
    }

    public static TaskQueryDto fromQuery(Query<?, ?> query) {
        return TaskQueryDto.fromQuery(query, false);
    }

    public static TaskQueryDto fromQuery(Query<?, ?> query, boolean isOrQueryActive) {
        Map expressions;
        List orderingProperties;
        TaskQueryImpl taskQuery = (TaskQueryImpl)query;
        TaskQueryDto dto = new TaskQueryDto();
        if (!isOrQueryActive) {
            dto.orQueries = new ArrayList<TaskQueryDto>();
            for (TaskQueryImpl orQuery : taskQuery.getQueries()) {
                if (!orQuery.isOrQueryActive()) continue;
                dto.orQueries.add(TaskQueryDto.fromQuery(orQuery, true));
            }
        }
        dto.activityInstanceIdIn = taskQuery.getActivityInstanceIdIn();
        dto.caseDefinitionId = taskQuery.getCaseDefinitionId();
        dto.caseDefinitionKey = taskQuery.getCaseDefinitionKey();
        dto.caseDefinitionName = taskQuery.getCaseDefinitionName();
        dto.caseDefinitionNameLike = taskQuery.getCaseDefinitionNameLike();
        dto.caseExecutionId = taskQuery.getCaseExecutionId();
        dto.caseInstanceBusinessKey = taskQuery.getCaseInstanceBusinessKey();
        dto.caseInstanceBusinessKeyLike = taskQuery.getCaseInstanceBusinessKeyLike();
        dto.caseInstanceId = taskQuery.getCaseInstanceId();
        dto.candidateUser = taskQuery.getCandidateUser();
        dto.candidateGroup = taskQuery.getCandidateGroup();
        dto.candidateGroupLike = taskQuery.getCandidateGroupLike();
        dto.candidateGroups = taskQuery.getCandidateGroupsInternal();
        dto.includeAssignedTasks = taskQuery.isIncludeAssignedTasksInternal();
        dto.withCandidateGroups = taskQuery.isWithCandidateGroups();
        dto.withoutCandidateGroups = taskQuery.isWithoutCandidateGroups();
        dto.withCandidateUsers = taskQuery.isWithCandidateUsers();
        dto.withoutCandidateUsers = taskQuery.isWithoutCandidateUsers();
        dto.processInstanceBusinessKey = taskQuery.getProcessInstanceBusinessKey();
        dto.processInstanceBusinessKeyLike = taskQuery.getProcessInstanceBusinessKeyLike();
        dto.processDefinitionKey = taskQuery.getProcessDefinitionKey();
        dto.processDefinitionKeyIn = taskQuery.getProcessDefinitionKeys();
        dto.processDefinitionId = taskQuery.getProcessDefinitionId();
        dto.executionId = taskQuery.getExecutionId();
        dto.processDefinitionName = taskQuery.getProcessDefinitionName();
        dto.processDefinitionNameLike = taskQuery.getProcessDefinitionNameLike();
        dto.processInstanceId = taskQuery.getProcessInstanceId();
        if (taskQuery.getProcessInstanceIdIn() != null) {
            dto.processInstanceIdIn = taskQuery.getProcessInstanceIdIn();
        }
        dto.assignee = taskQuery.getAssignee();
        if (taskQuery.getAssigneeIn() != null) {
            dto.assigneeIn = taskQuery.getAssigneeIn().toArray(new String[taskQuery.getAssigneeIn().size()]);
        }
        dto.assigneeLike = taskQuery.getAssigneeLike();
        dto.taskDefinitionKey = taskQuery.getKey();
        dto.taskDefinitionKeyIn = taskQuery.getKeys();
        dto.taskDefinitionKeyNotIn = taskQuery.getKeyNotIn();
        dto.taskDefinitionKeyLike = taskQuery.getKeyLike();
        dto.description = taskQuery.getDescription();
        dto.descriptionLike = taskQuery.getDescriptionLike();
        dto.involvedUser = taskQuery.getInvolvedUser();
        dto.maxPriority = taskQuery.getMaxPriority();
        dto.minPriority = taskQuery.getMinPriority();
        dto.name = taskQuery.getName();
        dto.nameNotEqual = taskQuery.getNameNotEqual();
        dto.nameLike = taskQuery.getNameLike();
        dto.nameNotLike = taskQuery.getNameNotLike();
        dto.owner = taskQuery.getOwner();
        dto.priority = taskQuery.getPriority();
        dto.assigned = taskQuery.isAssignedInternal();
        dto.unassigned = taskQuery.isUnassignedInternal();
        dto.parentTaskId = taskQuery.getParentTaskId();
        dto.dueAfter = taskQuery.getDueAfter();
        dto.dueBefore = taskQuery.getDueBefore();
        dto.dueDate = taskQuery.getDueDate();
        if (taskQuery.isWithoutDueDate()) {
            dto.withoutDueDate = taskQuery.isWithoutDueDate();
        }
        dto.followUpAfter = taskQuery.getFollowUpAfter();
        dto.variableNamesIgnoreCase = taskQuery.isVariableNamesIgnoreCase();
        dto.variableValuesIgnoreCase = taskQuery.isVariableValuesIgnoreCase();
        if (taskQuery.isFollowUpNullAccepted()) {
            dto.followUpBeforeOrNotExistent = taskQuery.getFollowUpBefore();
        } else {
            dto.followUpBefore = taskQuery.getFollowUpBefore();
        }
        dto.followUpDate = taskQuery.getFollowUpDate();
        dto.createdAfter = taskQuery.getCreateTimeAfter();
        dto.createdBefore = taskQuery.getCreateTimeBefore();
        dto.createdOn = taskQuery.getCreateTime();
        dto.updatedAfter = taskQuery.getUpdatedAfter();
        if (taskQuery.getDelegationState() != null) {
            dto.delegationState = taskQuery.getDelegationState().toString();
        }
        if (taskQuery.isWithoutTenantId()) {
            if (taskQuery.getTenantIds() != null) {
                dto.tenantIdIn = taskQuery.getTenantIds();
            } else {
                dto.withoutTenantId = true;
            }
        }
        dto.processVariables = new ArrayList<VariableQueryParameterDto>();
        dto.taskVariables = new ArrayList<VariableQueryParameterDto>();
        dto.caseInstanceVariables = new ArrayList<VariableQueryParameterDto>();
        for (TaskQueryVariableValue variableValue : taskQuery.getVariables()) {
            VariableQueryParameterDto variableValueDto = new VariableQueryParameterDto(variableValue);
            if (variableValue.isProcessInstanceVariable()) {
                dto.processVariables.add(variableValueDto);
                continue;
            }
            if (variableValue.isLocal()) {
                dto.taskVariables.add(variableValueDto);
                continue;
            }
            dto.caseInstanceVariables.add(variableValueDto);
        }
        if (taskQuery.getSuspensionState() == SuspensionState.ACTIVE) {
            dto.active = true;
        }
        if (taskQuery.getSuspensionState() == SuspensionState.SUSPENDED) {
            dto.suspended = true;
        }
        if (!(orderingProperties = taskQuery.getOrderingProperties()).isEmpty()) {
            dto.setSorting(TaskQueryDto.convertQueryOrderingPropertiesToSortingDtos(orderingProperties));
        }
        if ((expressions = taskQuery.getExpressions()).containsKey("taskAssignee")) {
            dto.setAssigneeExpression((String)expressions.get("taskAssignee"));
        }
        if (expressions.containsKey("taskAssigneeLike")) {
            dto.setAssigneeLikeExpression((String)expressions.get("taskAssigneeLike"));
        }
        if (expressions.containsKey("taskOwner")) {
            dto.setOwnerExpression((String)expressions.get("taskOwner"));
        }
        if (expressions.containsKey("taskCandidateUser")) {
            dto.setCandidateUserExpression((String)expressions.get("taskCandidateUser"));
        }
        if (expressions.containsKey("taskInvolvedUser")) {
            dto.setInvolvedUserExpression((String)expressions.get("taskInvolvedUser"));
        }
        if (expressions.containsKey("taskCandidateGroup")) {
            dto.setCandidateGroupExpression((String)expressions.get("taskCandidateGroup"));
        }
        if (expressions.containsKey("taskCandidateGroupIn")) {
            dto.setCandidateGroupsExpression((String)expressions.get("taskCandidateGroupIn"));
        }
        if (expressions.containsKey("taskCreatedOn")) {
            dto.setCreatedOnExpression((String)expressions.get("taskCreatedOn"));
        }
        if (expressions.containsKey("taskCreatedBefore")) {
            dto.setCreatedBeforeExpression((String)expressions.get("taskCreatedBefore"));
        }
        if (expressions.containsKey("taskCreatedAfter")) {
            dto.setCreatedAfterExpression((String)expressions.get("taskCreatedAfter"));
        }
        if (expressions.containsKey("taskUpdatedAfter")) {
            dto.setUpdatedAfterExpression((String)expressions.get("taskUpdatedAfter"));
        }
        if (expressions.containsKey(SORT_BY_DUE_DATE_VALUE)) {
            dto.setDueDateExpression((String)expressions.get(SORT_BY_DUE_DATE_VALUE));
        }
        if (expressions.containsKey("dueBefore")) {
            dto.setDueBeforeExpression((String)expressions.get("dueBefore"));
        }
        if (expressions.containsKey("dueAfter")) {
            dto.setDueAfterExpression((String)expressions.get("dueAfter"));
        }
        if (expressions.containsKey(SORT_BY_FOLLOW_UP_VALUE)) {
            dto.setFollowUpDateExpression((String)expressions.get(SORT_BY_FOLLOW_UP_VALUE));
        }
        if (expressions.containsKey("followUpBefore")) {
            dto.setFollowUpBeforeExpression((String)expressions.get("followUpBefore"));
        }
        if (expressions.containsKey("followUpBeforeOrNotExistent")) {
            dto.setFollowUpBeforeOrNotExistentExpression((String)expressions.get("followUpBeforeOrNotExistent"));
        }
        if (expressions.containsKey("followUpAfter")) {
            dto.setFollowUpAfterExpression((String)expressions.get("followUpAfter"));
        }
        if (expressions.containsKey("processInstanceBusinessKey")) {
            dto.setProcessInstanceBusinessKeyExpression((String)expressions.get("processInstanceBusinessKey"));
        }
        if (expressions.containsKey("processInstanceBusinessKeyLike")) {
            dto.setProcessInstanceBusinessKeyLikeExpression((String)expressions.get("processInstanceBusinessKeyLike"));
        }
        return dto;
    }

    public static List<SortingDto> convertQueryOrderingPropertiesToSortingDtos(List<QueryOrderingProperty> orderingProperties) {
        ArrayList<SortingDto> sortingDtos = new ArrayList<SortingDto>();
        for (QueryOrderingProperty orderingProperty : orderingProperties) {
            SortingDto sortingDto = orderingProperty instanceof VariableOrderProperty ? TaskQueryDto.convertVariableOrderPropertyToSortingDto((VariableOrderProperty)orderingProperty) : TaskQueryDto.convertQueryOrderingPropertyToSortingDto(orderingProperty);
            sortingDtos.add(sortingDto);
        }
        return sortingDtos;
    }

    public static SortingDto convertVariableOrderPropertyToSortingDto(VariableOrderProperty variableOrderProperty) {
        SortingDto sortingDto = new SortingDto();
        sortingDto.setSortBy(TaskQueryDto.sortByValueForVariableOrderProperty(variableOrderProperty));
        sortingDto.setSortOrder(TaskQueryDto.sortOrderValueForDirection(variableOrderProperty.getDirection()));
        sortingDto.setParameters(TaskQueryDto.sortParametersForVariableOrderProperty(variableOrderProperty));
        return sortingDto;
    }

    public static SortingDto convertQueryOrderingPropertyToSortingDto(QueryOrderingProperty orderingProperty) {
        SortingDto sortingDto = new SortingDto();
        sortingDto.setSortBy(TaskQueryDto.sortByValueForQueryProperty(orderingProperty.getQueryProperty()));
        sortingDto.setSortOrder(TaskQueryDto.sortOrderValueForDirection(orderingProperty.getDirection()));
        return sortingDto;
    }

    public static String sortByValueForQueryProperty(QueryProperty queryProperty) {
        if (TaskQueryProperty.ASSIGNEE.equals(queryProperty)) {
            return SORT_BY_ASSIGNEE_VALUE;
        }
        if (TaskQueryProperty.CASE_EXECUTION_ID.equals(queryProperty)) {
            return SORT_BY_CASE_EXECUTION_ID_VALUE;
        }
        if (TaskQueryProperty.CASE_INSTANCE_ID.equals(queryProperty)) {
            return SORT_BY_CASE_INSTANCE_ID_VALUE;
        }
        if (TaskQueryProperty.CREATE_TIME.equals(queryProperty)) {
            return SORT_BY_CREATE_TIME_VALUE;
        }
        if (TaskQueryProperty.LAST_UPDATED.equals(queryProperty)) {
            return SORT_BY_LAST_UPDATED_VALUE;
        }
        if (TaskQueryProperty.DESCRIPTION.equals(queryProperty)) {
            return SORT_BY_DESCRIPTION_VALUE;
        }
        if (TaskQueryProperty.DUE_DATE.equals(queryProperty)) {
            return SORT_BY_DUE_DATE_VALUE;
        }
        if (TaskQueryProperty.EXECUTION_ID.equals(queryProperty)) {
            return SORT_BY_EXECUTION_ID_VALUE;
        }
        if (TaskQueryProperty.FOLLOW_UP_DATE.equals(queryProperty)) {
            return SORT_BY_FOLLOW_UP_VALUE;
        }
        if (TaskQueryProperty.NAME.equals(queryProperty)) {
            return SORT_BY_NAME_VALUE;
        }
        if (TaskQueryProperty.NAME_CASE_INSENSITIVE.equals(queryProperty)) {
            return SORT_BY_NAME_CASE_INSENSITIVE_VALUE;
        }
        if (TaskQueryProperty.PRIORITY.equals(queryProperty)) {
            return SORT_BY_PRIORITY_VALUE;
        }
        if (TaskQueryProperty.PROCESS_INSTANCE_ID.equals(queryProperty)) {
            return SORT_BY_PROCESS_INSTANCE_ID_VALUE;
        }
        if (TaskQueryProperty.TASK_ID.equals(queryProperty)) {
            return SORT_BY_ID_VALUE;
        }
        if (TaskQueryProperty.TENANT_ID.equals(queryProperty)) {
            return SORT_BY_TENANT_ID_VALUE;
        }
        throw new RestException("Unknown query property for task query " + String.valueOf(queryProperty));
    }

    public static String sortByValueForVariableOrderProperty(VariableOrderProperty variableOrderProperty) {
        for (QueryEntityRelationCondition relationCondition : variableOrderProperty.getRelationConditions()) {
            if (!relationCondition.isPropertyComparison()) continue;
            return TaskQueryDto.sortByValueForQueryEntityRelationCondition(relationCondition);
        }
        throw new RestException("Unknown variable order property for task query " + String.valueOf(variableOrderProperty));
    }

    public static String sortByValueForQueryEntityRelationCondition(QueryEntityRelationCondition relationCondition) {
        QueryProperty property = relationCondition.getProperty();
        QueryProperty comparisonProperty = relationCondition.getComparisonProperty();
        if (VariableInstanceQueryProperty.EXECUTION_ID.equals(property) && TaskQueryProperty.PROCESS_INSTANCE_ID.equals(comparisonProperty)) {
            return SORT_BY_PROCESS_VARIABLE;
        }
        if (VariableInstanceQueryProperty.EXECUTION_ID.equals(property) && TaskQueryProperty.EXECUTION_ID.equals(comparisonProperty)) {
            return SORT_BY_EXECUTION_VARIABLE;
        }
        if (VariableInstanceQueryProperty.TASK_ID.equals(property) && TaskQueryProperty.TASK_ID.equals(comparisonProperty)) {
            return SORT_BY_TASK_VARIABLE;
        }
        if (VariableInstanceQueryProperty.CASE_EXECUTION_ID.equals(property) && TaskQueryProperty.CASE_INSTANCE_ID.equals(comparisonProperty)) {
            return SORT_BY_CASE_INSTANCE_VARIABLE;
        }
        if (VariableInstanceQueryProperty.CASE_EXECUTION_ID.equals(property) && TaskQueryProperty.CASE_EXECUTION_ID.equals(comparisonProperty)) {
            return SORT_BY_CASE_EXECUTION_VARIABLE;
        }
        throw new RestException("Unknown relation condition for task query  with query property " + String.valueOf(property) + " and comparison property " + String.valueOf(comparisonProperty));
    }

    public static Map<String, Object> sortParametersForVariableOrderProperty(VariableOrderProperty variableOrderProperty) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (QueryEntityRelationCondition relationCondition : variableOrderProperty.getRelationConditions()) {
            QueryProperty property = relationCondition.getProperty();
            if (VariableInstanceQueryProperty.VARIABLE_NAME.equals(property)) {
                parameters.put(SORT_PARAMETERS_VARIABLE_NAME, relationCondition.getScalarValue());
                continue;
            }
            if (!VariableInstanceQueryProperty.VARIABLE_TYPE.equals(property)) continue;
            String type = VariableValueDto.toRestApiTypeName((String)relationCondition.getScalarValue());
            parameters.put(SORT_PARAMETERS_VALUE_TYPE, type);
        }
        return parameters;
    }

    @Generated
    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    @Generated
    public String getProcessInstanceBusinessKeyExpression() {
        return this.processInstanceBusinessKeyExpression;
    }

    @Generated
    public String[] getProcessInstanceBusinessKeyIn() {
        return this.processInstanceBusinessKeyIn;
    }

    @Generated
    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    @Generated
    public String getProcessInstanceBusinessKeyLikeExpression() {
        return this.processInstanceBusinessKeyLikeExpression;
    }

    @Generated
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Generated
    public String[] getProcessDefinitionKeyIn() {
        return this.processDefinitionKeyIn;
    }

    @Generated
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public String[] getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    @Generated
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Generated
    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    @Generated
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Generated
    public String[] getProcessInstanceIdIn() {
        return this.processInstanceIdIn;
    }

    @Generated
    public String getAssignee() {
        return this.assignee;
    }

    @Generated
    public String getAssigneeExpression() {
        return this.assigneeExpression;
    }

    @Generated
    public String getAssigneeLike() {
        return this.assigneeLike;
    }

    @Generated
    public String getAssigneeLikeExpression() {
        return this.assigneeLikeExpression;
    }

    @Generated
    public String[] getAssigneeIn() {
        return this.assigneeIn;
    }

    @Generated
    public String[] getAssigneeNotIn() {
        return this.assigneeNotIn;
    }

    @Generated
    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    @Generated
    public String getCandidateGroupExpression() {
        return this.candidateGroupExpression;
    }

    @Generated
    public String getCandidateGroupLike() {
        return this.candidateGroupLike;
    }

    @Generated
    public String getCandidateUser() {
        return this.candidateUser;
    }

    @Generated
    public String getCandidateUserExpression() {
        return this.candidateUserExpression;
    }

    @Generated
    public Boolean getIncludeAssignedTasks() {
        return this.includeAssignedTasks;
    }

    @Generated
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    @Generated
    public String[] getTaskDefinitionKeyIn() {
        return this.taskDefinitionKeyIn;
    }

    @Generated
    public String[] getTaskDefinitionKeyNotIn() {
        return this.taskDefinitionKeyNotIn;
    }

    @Generated
    public String getTaskDefinitionKeyLike() {
        return this.taskDefinitionKeyLike;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String[] getTaskIdIn() {
        return this.taskIdIn;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    @Generated
    public String getInvolvedUser() {
        return this.involvedUser;
    }

    @Generated
    public String getInvolvedUserExpression() {
        return this.involvedUserExpression;
    }

    @Generated
    public Integer getMaxPriority() {
        return this.maxPriority;
    }

    @Generated
    public Integer getMinPriority() {
        return this.minPriority;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getNameNotEqual() {
        return this.nameNotEqual;
    }

    @Generated
    public String getNameLike() {
        return this.nameLike;
    }

    @Generated
    public String getNameNotLike() {
        return this.nameNotLike;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getOwnerExpression() {
        return this.ownerExpression;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    @Generated
    public Boolean getAssigned() {
        return this.assigned;
    }

    @Generated
    public Boolean getUnassigned() {
        return this.unassigned;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Boolean getSuspended() {
        return this.suspended;
    }

    @Generated
    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    @Generated
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    @Generated
    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    @Generated
    public String getCaseDefinitionNameLike() {
        return this.caseDefinitionNameLike;
    }

    @Generated
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Generated
    public String getCaseInstanceBusinessKey() {
        return this.caseInstanceBusinessKey;
    }

    @Generated
    public String getCaseInstanceBusinessKeyLike() {
        return this.caseInstanceBusinessKeyLike;
    }

    @Generated
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    @Generated
    public Date getDueAfter() {
        return this.dueAfter;
    }

    @Generated
    public String getDueAfterExpression() {
        return this.dueAfterExpression;
    }

    @Generated
    public Date getDueBefore() {
        return this.dueBefore;
    }

    @Generated
    public String getDueBeforeExpression() {
        return this.dueBeforeExpression;
    }

    @Generated
    public Date getDueDate() {
        return this.dueDate;
    }

    @Generated
    public String getDueDateExpression() {
        return this.dueDateExpression;
    }

    @Generated
    public Boolean getWithoutDueDate() {
        return this.withoutDueDate;
    }

    @Generated
    public Date getFollowUpAfter() {
        return this.followUpAfter;
    }

    @Generated
    public String getFollowUpAfterExpression() {
        return this.followUpAfterExpression;
    }

    @Generated
    public Date getFollowUpBefore() {
        return this.followUpBefore;
    }

    @Generated
    public String getFollowUpBeforeExpression() {
        return this.followUpBeforeExpression;
    }

    @Generated
    public Date getFollowUpBeforeOrNotExistent() {
        return this.followUpBeforeOrNotExistent;
    }

    @Generated
    public String getFollowUpBeforeOrNotExistentExpression() {
        return this.followUpBeforeOrNotExistentExpression;
    }

    @Generated
    public Date getFollowUpDate() {
        return this.followUpDate;
    }

    @Generated
    public String getFollowUpDateExpression() {
        return this.followUpDateExpression;
    }

    @Generated
    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    @Generated
    public String getCreatedAfterExpression() {
        return this.createdAfterExpression;
    }

    @Generated
    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    @Generated
    public String getCreatedBeforeExpression() {
        return this.createdBeforeExpression;
    }

    @Generated
    public Date getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public String getCreatedOnExpression() {
        return this.createdOnExpression;
    }

    @Generated
    public Date getUpdatedAfter() {
        return this.updatedAfter;
    }

    @Generated
    public String getUpdatedAfterExpression() {
        return this.updatedAfterExpression;
    }

    @Generated
    public String getDelegationState() {
        return this.delegationState;
    }

    @Generated
    public String[] getTenantIdIn() {
        return this.tenantIdIn;
    }

    @Generated
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    @Generated
    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    @Generated
    public String getCandidateGroupsExpression() {
        return this.candidateGroupsExpression;
    }

    @Generated
    public Boolean getWithCandidateGroups() {
        return this.withCandidateGroups;
    }

    @Generated
    public Boolean getWithoutCandidateGroups() {
        return this.withoutCandidateGroups;
    }

    @Generated
    public Boolean getWithCandidateUsers() {
        return this.withCandidateUsers;
    }

    @Generated
    public Boolean getWithoutCandidateUsers() {
        return this.withoutCandidateUsers;
    }

    @Generated
    public Boolean getVariableNamesIgnoreCase() {
        return this.variableNamesIgnoreCase;
    }

    @Generated
    public Boolean getVariableValuesIgnoreCase() {
        return this.variableValuesIgnoreCase;
    }

    @Generated
    public List<VariableQueryParameterDto> getTaskVariables() {
        return this.taskVariables;
    }

    @Generated
    public List<VariableQueryParameterDto> getProcessVariables() {
        return this.processVariables;
    }

    @Generated
    public List<VariableQueryParameterDto> getCaseInstanceVariables() {
        return this.caseInstanceVariables;
    }

    @Generated
    public List<TaskQueryDto> getOrQueries() {
        return this.orQueries;
    }

    @Generated
    public Boolean getWithCommentAttachmentInfo() {
        return this.withCommentAttachmentInfo;
    }

    @Generated
    public Boolean getWithTaskVariablesInReturn() {
        return this.withTaskVariablesInReturn;
    }

    @Generated
    public Boolean getWithTaskLocalVariablesInReturn() {
        return this.withTaskLocalVariablesInReturn;
    }

    @Generated
    public TaskQueryDto() {
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DUE_DATE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_FOLLOW_UP_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ASSIGNEE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CREATE_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_LAST_UPDATED_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DESCRIPTION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_CASE_INSENSITIVE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PRIORITY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID_VALUE);
    }
}

