/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.exception;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.ParseException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.eximeebpms.bpm.engine.migration.MigrationPlanValidationException;
import org.eximeebpms.bpm.engine.rest.dto.AuthorizationExceptionDto;
import org.eximeebpms.bpm.engine.rest.dto.ExceptionDto;
import org.eximeebpms.bpm.engine.rest.dto.ParseExceptionDto;
import org.eximeebpms.bpm.engine.rest.dto.migration.MigratingProcessInstanceValidationExceptionDto;
import org.eximeebpms.bpm.engine.rest.dto.migration.MigrationPlanValidationExceptionDto;
import org.eximeebpms.bpm.engine.rest.exception.ExceptionLogger;
import org.eximeebpms.bpm.engine.rest.exception.RestException;

public class ExceptionHandlerHelper {
    protected static final ExceptionLogger LOGGER = ExceptionLogger.REST_LOGGER;
    protected static final ExceptionHandlerHelper INSTANCE = new ExceptionHandlerHelper();

    private ExceptionHandlerHelper() {
    }

    public static ExceptionHandlerHelper getInstance() {
        return INSTANCE;
    }

    public Response getResponse(Throwable throwable) {
        LOGGER.log(throwable);
        Response.Status responseStatus = this.getStatus(throwable);
        ExceptionDto exceptionDto = this.fromException(throwable);
        return Response.status((Response.Status)responseStatus).entity((Object)exceptionDto).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected void provideExceptionCode(Throwable throwable, ExceptionDto exceptionDto) {
        Throwable cause;
        Integer code = null;
        if (throwable instanceof ProcessEngineException) {
            code = this.getCode(throwable);
        } else if (throwable instanceof RestException && (cause = throwable.getCause()) instanceof ProcessEngineException) {
            code = this.getCode(cause);
        }
        if (code != null) {
            exceptionDto.setCode(code);
        }
    }

    protected Integer getCode(Throwable throwable) {
        ProcessEngineException pex = (ProcessEngineException)throwable;
        return pex.getCode();
    }

    public ExceptionDto fromException(Throwable e) {
        ExceptionDto exceptionDto = e instanceof MigratingProcessInstanceValidationException ? MigratingProcessInstanceValidationExceptionDto.from((MigratingProcessInstanceValidationException)e) : (e instanceof MigrationPlanValidationException ? MigrationPlanValidationExceptionDto.from((MigrationPlanValidationException)e) : (e instanceof AuthorizationException ? AuthorizationExceptionDto.fromException((AuthorizationException)e) : (e instanceof ParseException ? ParseExceptionDto.fromException((ParseException)e) : ExceptionDto.fromException(e))));
        this.provideExceptionCode(e, exceptionDto);
        return exceptionDto;
    }

    public Response.Status getStatus(Throwable exception) {
        Response.Status responseStatus = Response.Status.INTERNAL_SERVER_ERROR;
        if (exception instanceof ProcessEngineException) {
            responseStatus = this.getStatus((ProcessEngineException)exception);
        } else if (exception instanceof RestException) {
            responseStatus = this.getStatus((RestException)exception);
        } else if (exception instanceof WebApplicationException) {
            int statusCode = ((WebApplicationException)exception).getResponse().getStatus();
            responseStatus = Response.Status.fromStatusCode((int)statusCode);
        }
        return responseStatus;
    }

    public Response.Status getStatus(ProcessEngineException exception) {
        Response.Status responseStatus = Response.Status.INTERNAL_SERVER_ERROR;
        if (exception instanceof AuthorizationException) {
            responseStatus = Response.Status.FORBIDDEN;
        } else if (exception instanceof MigrationPlanValidationException || exception instanceof MigratingProcessInstanceValidationException || exception instanceof BadUserRequestException || exception instanceof ParseException) {
            responseStatus = Response.Status.BAD_REQUEST;
        }
        return responseStatus;
    }

    public Response.Status getStatus(RestException exception) {
        if (exception.getStatus() != null) {
            return exception.getStatus();
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

