/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.GroupQuery;
import org.eximeebpms.bpm.engine.rest.GroupRestService;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.ResourceOptionsDto;
import org.eximeebpms.bpm.engine.rest.dto.identity.GroupDto;
import org.eximeebpms.bpm.engine.rest.dto.identity.GroupQueryDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import org.eximeebpms.bpm.engine.rest.sub.identity.GroupResource;
import org.eximeebpms.bpm.engine.rest.sub.identity.impl.GroupResourceImpl;
import org.eximeebpms.bpm.engine.rest.util.PathUtil;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;

public class GroupRestServiceImpl
extends AbstractAuthorizedRestResource
implements GroupRestService {
    public GroupRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, (Resource)Resources.GROUP, "*", objectMapper);
    }

    @Override
    public GroupResource getGroup(String id) {
        id = PathUtil.decodePathParam(id);
        return new GroupResourceImpl(this.getProcessEngine().getName(), id, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<GroupDto> queryGroups(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        GroupQueryDto queryDto = new GroupQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryGroups(queryDto, firstResult, maxResults);
    }

    @Override
    public List<GroupDto> queryGroups(GroupQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.getObjectMapper());
        GroupQuery query = (GroupQuery)queryDto.toQuery(this.getProcessEngine());
        List<Group> resultList = QueryUtil.list(query, firstResult, maxResults);
        return GroupDto.fromGroupList(resultList);
    }

    @Override
    public CountResultDto getGroupCount(UriInfo uriInfo) {
        GroupQueryDto queryDto = new GroupQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryGroupCount(queryDto);
    }

    @Override
    public CountResultDto queryGroupCount(GroupQueryDto queryDto) {
        GroupQuery query = (GroupQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        return new CountResultDto(count);
    }

    @Override
    public void createGroup(GroupDto groupDto) {
        IdentityService identityService = this.getIdentityService();
        if (identityService.isReadOnly()) {
            throw new InvalidRequestException(Response.Status.FORBIDDEN, "Identity service implementation is read-only.");
        }
        Group newGroup = identityService.newGroup(groupDto.getId());
        groupDto.update(newGroup);
        identityService.saveGroup(newGroup);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        IdentityService identityService = this.getIdentityService();
        UriBuilder baseUriBuilder = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/group");
        ResourceOptionsDto resourceOptionsDto = new ResourceOptionsDto();
        URI baseUri = baseUriBuilder.build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(baseUri, "GET", "list");
        URI countUri = baseUriBuilder.clone().path("/count").build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(countUri, "GET", "count");
        if (!identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            URI createUri = baseUriBuilder.clone().path("/create").build(new Object[0]);
            resourceOptionsDto.addReflexiveLink(createUri, "POST", "create");
        }
        return resourceOptionsDto;
    }

    protected IdentityService getIdentityService() {
        return this.getProcessEngine().getIdentityService();
    }
}

