/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.HistoricIncident;
import org.eximeebpms.bpm.engine.history.HistoricIncidentQuery;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricIncidentDto;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricIncidentQueryDto;
import org.eximeebpms.bpm.engine.rest.history.HistoricIncidentRestService;
import org.eximeebpms.bpm.engine.rest.util.QueryUtil;

public class HistoricIncidentRestServiceImpl
implements HistoricIncidentRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricIncidentRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public List<HistoricIncidentDto> getHistoricIncidents(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricIncidentQueryDto queryDto = new HistoricIncidentQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricIncidentQuery query = (HistoricIncidentQuery)queryDto.toQuery(this.processEngine);
        List<HistoricIncident> queryResult = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricIncidentDto> result = new ArrayList<HistoricIncidentDto>();
        for (HistoricIncident historicIncident : queryResult) {
            HistoricIncidentDto dto = HistoricIncidentDto.fromHistoricIncident(historicIncident);
            result.add(dto);
        }
        return result;
    }

    @Override
    public CountResultDto getHistoricIncidentsCount(UriInfo uriInfo) {
        HistoricIncidentQueryDto queryDto = new HistoricIncidentQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricIncidentQuery query = (HistoricIncidentQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

