/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.mapper;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.fileupload.FileItemStream;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.rest.exception.RestException;

public class MultipartFormData {
    protected Map<String, FormPart> formParts = new HashMap<String, FormPart>();

    public void addPart(FormPart formPart) {
        this.formParts.put(formPart.getFieldName(), formPart);
    }

    public FormPart getNamedPart(String name) {
        return this.formParts.get(name);
    }

    public Set<String> getPartNames() {
        return this.formParts.keySet();
    }

    public static class FormPart {
        protected String fieldName;
        protected String contentType;
        protected String textContent;
        protected String fileName;
        protected byte[] binaryContent;

        public FormPart(FileItemStream stream) {
            this.fieldName = stream.getFieldName();
            this.contentType = stream.getContentType();
            this.binaryContent = this.readBinaryContent(stream);
            this.fileName = stream.getName();
            if (this.contentType == null || this.contentType.contains("text/plain")) {
                this.textContent = new String(this.binaryContent, StandardCharsets.UTF_8);
            }
        }

        public FormPart() {
        }

        protected byte[] readBinaryContent(FileItemStream stream) {
            InputStream inputStream = this.getInputStream(stream);
            return IoUtil.readInputStream((InputStream)inputStream, (String)stream.getFieldName());
        }

        protected InputStream getInputStream(FileItemStream stream) {
            try {
                return stream.openStream();
            }
            catch (IOException e) {
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e);
            }
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getTextContent() {
            return this.textContent;
        }

        public byte[] getBinaryContent() {
            return this.binaryContent;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

