/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.history.impl;

import jakarta.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricActivityInstanceDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.sub.history.HistoricActivityInstanceResource;

public class HistoricActivityInstanceResourceImpl
implements HistoricActivityInstanceResource {
    private ProcessEngine engine;
    private String activityInstanceId;

    public HistoricActivityInstanceResourceImpl(ProcessEngine engine, String activityInstanceId) {
        this.engine = engine;
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public HistoricActivityInstanceDto getHistoricActivityInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricActivityInstance instance = (HistoricActivityInstance)historyService.createHistoricActivityInstanceQuery().activityInstanceId(this.activityInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic activity instance with id '" + this.activityInstanceId + "' does not exist");
        }
        HistoricActivityInstanceDto historicActivityInstanceDto = new HistoricActivityInstanceDto();
        HistoricActivityInstanceDto.fromHistoricActivityInstance(historicActivityInstanceDto, instance);
        return historicActivityInstanceDto;
    }
}

