/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.history.impl;

import jakarta.ws.rs.core.Response;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.HistoricCaseInstance;
import org.eximeebpms.bpm.engine.rest.dto.history.HistoricCaseInstanceDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.sub.history.HistoricCaseInstanceResource;

public class HistoricCaseInstanceResourceImpl
implements HistoricCaseInstanceResource {
    private ProcessEngine engine;
    private String caseInstanceId;

    public HistoricCaseInstanceResourceImpl(ProcessEngine engine, String caseInstanceId) {
        this.engine = engine;
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public HistoricCaseInstanceDto getHistoricCaseInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricCaseInstance instance = (HistoricCaseInstance)historyService.createHistoricCaseInstanceQuery().caseInstanceId(this.caseInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic case instance with id '" + this.caseInstanceId + "' does not exist");
        }
        return HistoricCaseInstanceDto.fromHistoricCaseInstance(instance);
    }
}

