/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.core.Variant;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eximeebpms.bpm.engine.FilterService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.filter.Filter;
import org.eximeebpms.bpm.engine.impl.VariableInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.CountResultDto;
import org.eximeebpms.bpm.engine.rest.dto.ResourceOptionsDto;
import org.eximeebpms.bpm.engine.rest.dto.runtime.FilterDto;
import org.eximeebpms.bpm.engine.rest.dto.task.TaskDto;
import org.eximeebpms.bpm.engine.rest.dto.task.TaskQueryDto;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;
import org.eximeebpms.bpm.engine.rest.hal.EmptyHalCollection;
import org.eximeebpms.bpm.engine.rest.hal.EmptyHalResource;
import org.eximeebpms.bpm.engine.rest.hal.Hal;
import org.eximeebpms.bpm.engine.rest.hal.HalCollectionResource;
import org.eximeebpms.bpm.engine.rest.hal.HalResource;
import org.eximeebpms.bpm.engine.rest.hal.HalVariableValue;
import org.eximeebpms.bpm.engine.rest.hal.task.HalTask;
import org.eximeebpms.bpm.engine.rest.hal.task.HalTaskList;
import org.eximeebpms.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import org.eximeebpms.bpm.engine.rest.sub.runtime.FilterResource;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.task.Task;

public class FilterResourceImpl
extends AbstractAuthorizedRestResource
implements FilterResource {
    public static final Pattern EMPTY_JSON_BODY = Pattern.compile("\\s*\\{\\s*\\}\\s*");
    public static final String PROPERTIES_VARIABLES_KEY = "variables";
    public static final String PROPERTIES_VARIABLES_NAME_KEY = "name";
    public static final List<Variant> VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, Hal.APPLICATION_HAL_JSON_TYPE}).add().build();
    protected String relativeRootResourcePath;
    protected FilterService filterService;
    protected Filter dbFilter;

    public FilterResourceImpl(String processEngineName, ObjectMapper objectMapper, String filterId, String relativeRootResourcePath) {
        super(processEngineName, (Resource)Resources.FILTER, filterId, objectMapper);
        this.relativeRootResourcePath = relativeRootResourcePath;
        this.filterService = this.getProcessEngine().getFilterService();
    }

    @Override
    public FilterDto getFilter(Boolean itemCount) {
        Filter filter = this.getDbFilter();
        FilterDto dto = FilterDto.fromFilter(filter);
        if (itemCount != null && itemCount.booleanValue()) {
            dto.setItemCount(this.filterService.count(filter.getId()));
        }
        return dto;
    }

    protected Filter getDbFilter() {
        if (this.dbFilter == null) {
            this.dbFilter = this.filterService.getFilter(this.resourceId);
            if (this.dbFilter == null) {
                throw this.filterNotFound(null);
            }
        }
        return this.dbFilter;
    }

    @Override
    public void deleteFilter() {
        try {
            this.filterService.deleteFilter(this.resourceId);
        }
        catch (NullValueException e) {
            throw this.filterNotFound((Exception)((Object)e));
        }
    }

    @Override
    public void updateFilter(FilterDto filterDto) {
        Filter filter = this.getDbFilter();
        try {
            filterDto.updateFilter(filter, this.getProcessEngine());
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Unable to update filter with invalid content");
        }
        this.filterService.saveFilter(filter);
    }

    @Override
    public Object executeSingleResult(Request request) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.executeJsonSingleResult();
            }
            if (Hal.APPLICATION_HAL_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.executeHalSingleResult();
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    public Object executeJsonSingleResult() {
        return this.queryJsonSingleResult(null);
    }

    @Override
    public Object querySingleResult(Request request, String extendingQuery) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.queryJsonSingleResult(extendingQuery);
            }
            if (Hal.APPLICATION_HAL_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.queryHalSingleResult(extendingQuery);
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    public Object queryJsonSingleResult(String extendingQuery) {
        Object entity = this.executeFilterSingleResult(extendingQuery);
        if (entity != null) {
            return this.convertToDto(entity);
        }
        return null;
    }

    public HalResource executeHalSingleResult() {
        return this.queryHalSingleResult(null);
    }

    public HalResource queryHalSingleResult(String extendingQuery) {
        Object entity = this.executeFilterSingleResult(extendingQuery);
        if (entity != null) {
            return this.convertToHalResource(entity);
        }
        return EmptyHalResource.INSTANCE;
    }

    protected Object executeFilterSingleResult(String extendingQuery) {
        try {
            return this.filterService.singleResult(this.resourceId, this.convertQuery(extendingQuery));
        }
        catch (NullValueException e) {
            throw this.filterNotFound((Exception)((Object)e));
        }
        catch (NotValidException e) {
            throw this.invalidQuery((Exception)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Filter does not returns a valid single result");
        }
    }

    @Override
    public Object executeList(Request request, Integer firstResult, Integer maxResults) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.executeJsonList(firstResult, maxResults);
            }
            if (Hal.APPLICATION_HAL_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.executeHalList(firstResult, maxResults);
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    public List<Object> executeJsonList(Integer firstResult, Integer maxResults) {
        return this.queryJsonList(null, firstResult, maxResults);
    }

    @Override
    public Object queryList(Request request, String extendingQuery, Integer firstResult, Integer maxResults) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.queryJsonList(extendingQuery, firstResult, maxResults);
            }
            if (Hal.APPLICATION_HAL_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.queryHalList(extendingQuery, firstResult, maxResults);
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    public List<Object> queryJsonList(String extendingQuery, Integer firstResult, Integer maxResults) {
        List<?> entities = this.executeFilterList(extendingQuery, firstResult, maxResults);
        if (entities != null && !entities.isEmpty()) {
            return this.convertToDtoList(entities);
        }
        return Collections.emptyList();
    }

    public HalResource executeHalList(Integer firstResult, Integer maxResults) {
        return this.queryHalList(null, firstResult, maxResults);
    }

    public HalResource queryHalList(String extendingQuery, Integer firstResult, Integer maxResults) {
        List<?> entities = this.executeFilterList(extendingQuery, firstResult, maxResults);
        long count = this.executeFilterCount(extendingQuery);
        if (entities != null && !entities.isEmpty()) {
            return this.convertToHalCollection(entities, count);
        }
        return new EmptyHalCollection(count);
    }

    protected List<?> executeFilterList(String extendingQueryString, Integer firstResult, Integer maxResults) {
        Query extendingQuery = this.convertQuery(extendingQueryString);
        try {
            if (firstResult != null || maxResults != null) {
                if (firstResult == null) {
                    firstResult = 0;
                }
                if (maxResults == null) {
                    maxResults = Integer.MAX_VALUE;
                }
                return this.filterService.listPage(this.resourceId, extendingQuery, firstResult.intValue(), maxResults.intValue());
            }
            return this.filterService.list(this.resourceId, extendingQuery);
        }
        catch (NullValueException e) {
            throw this.filterNotFound((Exception)((Object)e));
        }
        catch (NotValidException e) {
            throw this.invalidQuery((Exception)((Object)e));
        }
    }

    @Override
    public CountResultDto executeCount() {
        return this.queryCount(null);
    }

    @Override
    public CountResultDto queryCount(String extendingQuery) {
        return new CountResultDto(this.executeFilterCount(extendingQuery));
    }

    protected long executeFilterCount(String extendingQuery) {
        try {
            return this.filterService.count(this.resourceId, this.convertQuery(extendingQuery));
        }
        catch (NullValueException e) {
            throw this.filterNotFound((Exception)((Object)e));
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Filter cannot be extended by an invalid query");
        }
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        UriBuilder baseUriBuilder = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/filter").path(this.resourceId);
        URI baseUri = baseUriBuilder.build(new Object[0]);
        if (this.isAuthorized((Permission)Permissions.READ)) {
            dto.addReflexiveLink(baseUri, "GET", "self");
            URI singleResultUri = baseUriBuilder.clone().path("/singleResult").build(new Object[0]);
            dto.addReflexiveLink(singleResultUri, "GET", "singleResult");
            dto.addReflexiveLink(singleResultUri, "POST", "singleResult");
            URI listUri = baseUriBuilder.clone().path("/list").build(new Object[0]);
            dto.addReflexiveLink(listUri, "GET", "list");
            dto.addReflexiveLink(listUri, "POST", "list");
            URI countUri = baseUriBuilder.clone().path("/count").build(new Object[0]);
            dto.addReflexiveLink(countUri, "GET", "count");
            dto.addReflexiveLink(countUri, "POST", "count");
        }
        if (this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(baseUri, "DELETE", "delete");
        }
        if (this.isAuthorized((Permission)Permissions.UPDATE)) {
            dto.addReflexiveLink(baseUri, "PUT", "update");
        }
        return dto;
    }

    protected Query convertQuery(String queryString) {
        if (this.isEmptyJson(queryString)) {
            return null;
        }
        String resourceType = this.getDbFilter().getResourceType();
        AbstractQueryDto<?> queryDto = this.getQueryDtoForQuery(queryString, resourceType);
        queryDto.setObjectMapper(this.getObjectMapper());
        return queryDto.toQuery(this.getProcessEngine());
    }

    protected Object convertToDto(Object entity) {
        if (this.isEntityOfClass(entity, Task.class)) {
            return TaskDto.fromEntity((Task)entity);
        }
        throw this.unsupportedEntityClass(entity);
    }

    protected List<Object> convertToDtoList(List<?> entities) {
        ArrayList<Object> dtoList = new ArrayList<Object>();
        for (Object entity : entities) {
            dtoList.add(this.convertToDto(entity));
        }
        return dtoList;
    }

    protected HalResource<?> convertToHalResource(Object entity) {
        if (this.isEntityOfClass(entity, Task.class)) {
            return this.convertToHalTask((Task)entity);
        }
        throw this.unsupportedEntityClass(entity);
    }

    protected HalTask convertToHalTask(Task task) {
        HalTask halTask = HalTask.generate(task, this.getProcessEngine());
        Map<String, List<VariableInstance>> variableInstances = this.getVariableInstancesForTasks(halTask);
        if (variableInstances != null) {
            this.embedVariableValuesInHalTask(halTask, variableInstances);
        }
        return halTask;
    }

    protected HalCollectionResource convertToHalCollection(List<?> entities, long count) {
        if (this.isEntityOfClass(entities.get(0), Task.class)) {
            return this.convertToHalTaskList(entities, count);
        }
        throw this.unsupportedEntityClass(entities.get(0));
    }

    protected HalTaskList convertToHalTaskList(List<Task> tasks, long count) {
        HalTaskList halTasks = HalTaskList.generate(tasks, count, this.getProcessEngine());
        Map<String, List<VariableInstance>> variableInstances = this.getVariableInstancesForTasks(halTasks);
        if (variableInstances != null) {
            for (HalTask halTask : (List)halTasks.getEmbedded("task")) {
                this.embedVariableValuesInHalTask(halTask, variableInstances);
            }
        }
        return halTasks;
    }

    protected void embedVariableValuesInHalTask(HalTask halTask, Map<String, List<VariableInstance>> variableInstances) {
        List<HalResource<?>> variableValues = this.getVariableValuesForTask(halTask, variableInstances);
        halTask.addEmbedded("variable", variableValues);
    }

    protected AbstractQueryDto<?> getQueryDtoForQuery(String queryString, String resourceType) {
        try {
            if ("Task".equals(resourceType)) {
                return (AbstractQueryDto)this.getObjectMapper().readValue(queryString, TaskQueryDto.class);
            }
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Queries for resource type '" + resourceType + "' are currently not supported by filters.");
        }
        catch (IOException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, "Invalid query for resource type '" + resourceType + "'");
        }
    }

    protected List<HalResource<?>> getVariableValuesForTask(HalTask halTask, Map<String, List<VariableInstance>> variableInstances) {
        ArrayList variableValues = new ArrayList();
        LinkedHashSet<String> variableScopeIds = this.getVariableScopeIds(halTask);
        HashSet<String> knownVariableNames = new HashSet<String>();
        for (String variableScopeId : variableScopeIds) {
            if (!variableInstances.containsKey(variableScopeId)) continue;
            for (VariableInstance variableInstance : variableInstances.get(variableScopeId)) {
                if (knownVariableNames.contains(variableInstance.getName())) continue;
                variableValues.add(HalVariableValue.generateVariableValue(variableInstance, variableScopeId));
                knownVariableNames.add(variableInstance.getName());
            }
        }
        return variableValues;
    }

    protected Map<String, List<VariableInstance>> getVariableInstancesForTasks(HalTaskList halTaskList) {
        List halTasks = (List)halTaskList.getEmbedded("task");
        return this.getVariableInstancesForTasks(halTasks.toArray(new HalTask[halTasks.size()]));
    }

    protected Map<String, List<VariableInstance>> getVariableInstancesForTasks(HalTask ... halTasks) {
        List<String> variableNames;
        if (halTasks != null && halTasks.length > 0 && (variableNames = this.getFilterVariableNames()) != null && !variableNames.isEmpty()) {
            LinkedHashSet<String> variableScopeIds = this.getVariableScopeIds(halTasks);
            return this.getSortedVariableInstances(variableNames, variableScopeIds);
        }
        return null;
    }

    protected List<String> getFilterVariableNames() {
        Map properties = this.getDbFilter().getProperties();
        if (properties != null) {
            try {
                List variables = (List)properties.get(PROPERTIES_VARIABLES_KEY);
                return this.collectVariableNames(variables);
            }
            catch (Exception e) {
                throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, e, "Filter property 'variables' has to be a list of variable definitions with a 'name' property");
            }
        }
        return null;
    }

    private List<String> collectVariableNames(List<Map<String, Object>> variables) {
        if (variables != null && !variables.isEmpty()) {
            ArrayList<String> variableNames = new ArrayList<String>();
            for (Map<String, Object> variable : variables) {
                variableNames.add((String)variable.get(PROPERTIES_VARIABLES_NAME_KEY));
            }
            return variableNames;
        }
        return null;
    }

    protected LinkedHashSet<String> getVariableScopeIds(HalTask ... halTasks) {
        LinkedHashSet<String> variableScopeIds = new LinkedHashSet<String>();
        if (halTasks != null && halTasks.length > 0) {
            for (HalTask halTask : halTasks) {
                variableScopeIds.add(halTask.getId());
                variableScopeIds.add(halTask.getExecutionId());
                variableScopeIds.add(halTask.getProcessInstanceId());
                variableScopeIds.add(halTask.getCaseExecutionId());
                variableScopeIds.add(halTask.getCaseInstanceId());
            }
        }
        variableScopeIds.remove(null);
        return variableScopeIds;
    }

    protected Map<String, List<VariableInstance>> getSortedVariableInstances(Collection<String> variableNames, Collection<String> variableScopeIds) {
        List<VariableInstance> variableInstances = this.queryVariablesInstancesByVariableScopeIds(variableNames, variableScopeIds);
        HashMap<String, List<VariableInstance>> sortedVariableInstances = new HashMap<String, List<VariableInstance>>();
        for (VariableInstance variableInstance : variableInstances) {
            String variableScopeId = ((VariableInstanceEntity)variableInstance).getVariableScopeId();
            if (!sortedVariableInstances.containsKey(variableScopeId)) {
                sortedVariableInstances.put(variableScopeId, new ArrayList());
            }
            ((List)sortedVariableInstances.get(variableScopeId)).add(variableInstance);
        }
        return sortedVariableInstances;
    }

    protected List<VariableInstance> queryVariablesInstancesByVariableScopeIds(Collection<String> variableNames, Collection<String> variableScopeIds) {
        VariableInstanceQueryImpl query = (VariableInstanceQueryImpl)this.getProcessEngine().getRuntimeService().createVariableInstanceQuery().disableBinaryFetching().disableCustomObjectDeserialization().variableNameIn(variableNames.toArray(new String[0])).variableScopeIdIn(variableScopeIds.toArray(new String[0]));
        return query.unlimitedList();
    }

    protected boolean isEntityOfClass(Object entity, Class<?> entityClass) {
        return entityClass.isAssignableFrom(entity.getClass());
    }

    protected boolean isEmptyJson(String jsonString) {
        return jsonString == null || jsonString.trim().isEmpty() || EMPTY_JSON_BODY.matcher(jsonString).matches();
    }

    protected InvalidRequestException filterNotFound(Exception cause) {
        return new InvalidRequestException(Response.Status.NOT_FOUND, cause, "Filter with id '" + this.resourceId + "' does not exist.");
    }

    protected InvalidRequestException invalidQuery(Exception cause) {
        return new InvalidRequestException(Response.Status.BAD_REQUEST, cause, "Filter cannot be extended by an invalid query");
    }

    protected InvalidRequestException unsupportedEntityClass(Object entity) {
        return new InvalidRequestException(Response.Status.BAD_REQUEST, "Entities of class '" + entity.getClass().getCanonicalName() + "' are currently not supported by filters.");
    }
}

