/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.externaltask;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.externaltask.ExternalTaskQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.EximeeBPMSQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.DateConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.LongConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringListConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringSetConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.VariableListConverter;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;

public class ExternalTaskQueryDto
extends AbstractQueryDto<ExternalTaskQuery> {
    public static final Map<String, Consumer<ExternalTaskQuery>> SORT_METHODS_BY_FIELD = Map.of("id", ExternalTaskQuery::orderById, "lockExpirationTime", ExternalTaskQuery::orderByLockExpirationTime, "processInstanceId", ExternalTaskQuery::orderByProcessInstanceId, "processDefinitionId", ExternalTaskQuery::orderByProcessDefinitionId, "processDefinitionKey", ExternalTaskQuery::orderByProcessDefinitionKey, "tenantId", ExternalTaskQuery::orderByTenantId, "taskPriority", ExternalTaskQuery::orderByPriority, "createTime", ExternalTaskQuery::orderByCreateTime);
    protected String externalTaskId;
    protected Set<String> externalTaskIds;
    protected String activityId;
    protected List<String> activityIdIn;
    protected Date lockExpirationBefore;
    protected Date lockExpirationAfter;
    protected String topicName;
    protected Boolean locked;
    protected Boolean notLocked;
    protected String executionId;
    protected String processInstanceId;
    protected List<String> processInstanceIdIn;
    protected String processDefinitionKey;
    protected String[] processDefinitionKeyIn;
    protected String processDefinitionId;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected Boolean active;
    protected Boolean suspended;
    protected Boolean withRetriesLeft;
    protected Boolean noRetriesLeft;
    protected String workerId;
    protected List<String> tenantIds;
    protected Long priorityHigherThanOrEquals;
    protected Long priorityLowerThanOrEquals;
    protected Boolean variableNamesIgnoreCase;
    protected Boolean variableValuesIgnoreCase;
    private List<VariableQueryParameterDto> processVariables;

    public ExternalTaskQueryDto() {
    }

    public ExternalTaskQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @EximeeBPMSQueryParam(value="externalTaskId")
    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @EximeeBPMSQueryParam(value="externalTaskIdIn", converter=StringSetConverter.class)
    public void setExternalTaskIdIn(Set<String> externalTaskIds) {
        this.externalTaskIds = externalTaskIds;
    }

    @EximeeBPMSQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @EximeeBPMSQueryParam(value="activityIdIn", converter=StringListConverter.class)
    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    @EximeeBPMSQueryParam(value="lockExpirationBefore", converter=DateConverter.class)
    public void setLockExpirationBefore(Date lockExpirationBefore) {
        this.lockExpirationBefore = lockExpirationBefore;
    }

    @EximeeBPMSQueryParam(value="lockExpirationAfter", converter=DateConverter.class)
    public void setLockExpirationAfter(Date lockExpirationAfter) {
        this.lockExpirationAfter = lockExpirationAfter;
    }

    @EximeeBPMSQueryParam(value="topicName")
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @EximeeBPMSQueryParam(value="locked", converter=BooleanConverter.class)
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    @EximeeBPMSQueryParam(value="notLocked", converter=BooleanConverter.class)
    public void setNotLocked(Boolean notLocked) {
        this.notLocked = notLocked;
    }

    @EximeeBPMSQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @EximeeBPMSQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @EximeeBPMSQueryParam(value="processInstanceIdIn", converter=StringListConverter.class)
    public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    @EximeeBPMSQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @EximeeBPMSQueryParam(value="processDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionKeyIn(String[] processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    @EximeeBPMSQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @EximeeBPMSQueryParam(value="processDefinitionName")
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @EximeeBPMSQueryParam(value="processDefinitionNameLike")
    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    @EximeeBPMSQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @EximeeBPMSQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @EximeeBPMSQueryParam(value="withRetriesLeft", converter=BooleanConverter.class)
    public void setWithRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
    }

    @EximeeBPMSQueryParam(value="noRetriesLeft", converter=BooleanConverter.class)
    public void setNoRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
    }

    @EximeeBPMSQueryParam(value="workerId")
    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    @EximeeBPMSQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @EximeeBPMSQueryParam(value="priorityHigherThanOrEquals", converter=LongConverter.class)
    public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
    }

    @EximeeBPMSQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesCaseInsensitive) {
        this.variableNamesIgnoreCase = variableNamesCaseInsensitive;
    }

    @EximeeBPMSQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesCaseInsensitive) {
        this.variableValuesIgnoreCase = variableValuesCaseInsensitive;
    }

    @EximeeBPMSQueryParam(value="processVariables", converter=VariableListConverter.class)
    public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
    }

    @EximeeBPMSQueryParam(value="priorityLowerThanOrEquals", converter=LongConverter.class)
    public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return SORT_METHODS_BY_FIELD.containsKey(value);
    }

    @Override
    protected ExternalTaskQuery createNewQuery(ProcessEngine engine) {
        return engine.getExternalTaskService().createExternalTaskQuery();
    }

    @Override
    protected void applyFilters(ExternalTaskQuery query) {
        if (this.externalTaskId != null) {
            query.externalTaskId(this.externalTaskId);
        }
        if (this.externalTaskIds != null && !this.externalTaskIds.isEmpty()) {
            query.externalTaskIdIn(this.externalTaskIds);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.activityIdIn != null && !this.activityIdIn.isEmpty()) {
            query.activityIdIn(this.activityIdIn.toArray(new String[0]));
        }
        if (this.lockExpirationBefore != null) {
            query.lockExpirationBefore(this.lockExpirationBefore);
        }
        if (this.lockExpirationAfter != null) {
            query.lockExpirationAfter(this.lockExpirationAfter);
        }
        if (this.topicName != null) {
            query.topicName(this.topicName);
        }
        if (this.locked != null && this.locked.booleanValue()) {
            query.locked();
        }
        if (this.notLocked != null && this.notLocked.booleanValue()) {
            query.notLocked();
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processInstanceIdIn != null && !this.processInstanceIdIn.isEmpty()) {
            query.processInstanceIdIn(this.processInstanceIdIn.toArray(new String[0]));
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionKeyIn != null && this.processDefinitionKeyIn.length > 0) {
            query.processDefinitionKeyIn(this.processDefinitionKeyIn);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionName != null) {
            query.processDefinitionName(this.processDefinitionName);
        }
        if (this.processDefinitionNameLike != null) {
            query.processDefinitionNameLike(this.processDefinitionNameLike);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.priorityHigherThanOrEquals != null) {
            query.priorityHigherThanOrEquals(this.priorityHigherThanOrEquals.longValue());
        }
        if (this.priorityLowerThanOrEquals != null) {
            query.priorityLowerThanOrEquals(this.priorityLowerThanOrEquals.longValue());
        }
        if (this.withRetriesLeft != null && this.withRetriesLeft.booleanValue()) {
            query.withRetriesLeft();
        }
        if (this.noRetriesLeft != null && this.noRetriesLeft.booleanValue()) {
            query.noRetriesLeft();
        }
        if (this.variableValuesIgnoreCase != null && this.variableValuesIgnoreCase.booleanValue()) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.variableNamesIgnoreCase != null && this.variableNamesIgnoreCase.booleanValue()) {
            query.matchVariableNamesIgnoreCase();
        }
        if (this.processVariables != null) {
            block20: for (VariableQueryParameterDto variableQueryParam : this.processVariables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.resolveValue(this.objectMapper);
                switch (op) {
                    case "eq": {
                        query.processVariableValueEquals(variableName, variableValue);
                        continue block20;
                    }
                    case "neq": {
                        query.processVariableValueNotEquals(variableName, variableValue);
                        continue block20;
                    }
                    case "gt": {
                        query.processVariableValueGreaterThan(variableName, variableValue);
                        continue block20;
                    }
                    case "gteq": {
                        query.processVariableValueGreaterThanOrEquals(variableName, variableValue);
                        continue block20;
                    }
                    case "lt": {
                        query.processVariableValueLessThan(variableName, variableValue);
                        continue block20;
                    }
                    case "lteq": {
                        query.processVariableValueLessThanOrEquals(variableName, variableValue);
                        continue block20;
                    }
                    case "like": {
                        query.processVariableValueLike(variableName, String.valueOf(variableValue));
                        continue block20;
                    }
                    case "notLike": {
                        query.processVariableValueNotLike(variableName, String.valueOf(variableValue));
                        continue block20;
                    }
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid process variable comparator specified: " + op);
            }
        }
        if (this.workerId != null) {
            query.workerId(this.workerId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[0]));
        }
    }

    @Override
    protected void applySortBy(ExternalTaskQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        Consumer<ExternalTaskQuery> sortByMethod = SORT_METHODS_BY_FIELD.get(sortBy);
        if (sortByMethod != null) {
            sortByMethod.accept(query);
        }
    }

    @Generated
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }
}

