/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.HistoricJobLogQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.EximeeBPMSQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.LongConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringListConverter;

public class HistoricJobLogQueryDto
extends AbstractQueryDto<HistoricJobLogQuery> {
    protected static final String SORT_BY_TIMESTAMP = "timestamp";
    protected static final String SORT_BY_JOB_ID = "jobId";
    protected static final String SORT_BY_JOB_DUE_DATE = "jobDueDate";
    protected static final String SORT_BY_JOB_RETRIES = "jobRetries";
    protected static final String SORT_BY_JOB_PRIORITY = "jobPriority";
    protected static final String SORT_BY_JOB_DEFINITION_ID = "jobDefinitionId";
    protected static final String SORT_BY_ACTIVITY_ID = "activityId";
    protected static final String SORT_BY_EXECUTION_ID = "executionId";
    protected static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    protected static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String SORT_BY_DEPLOYMENT_ID = "deploymentId";
    protected static final String SORT_PARTIALLY_BY_OCCURRENCE = "occurrence";
    protected static final String SORT_BY_TENANT_ID = "tenantId";
    protected static final String SORT_BY_HOSTNAME = "hostname";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String id;
    protected String jobId;
    protected String jobExceptionMessage;
    protected String jobDefinitionId;
    protected String jobDefinitionType;
    protected String jobDefinitionConfiguration;
    protected String[] activityIds;
    protected String[] failedActivityIds;
    protected String[] executionIds;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String deploymentId;
    protected Boolean creationLog;
    protected Boolean failureLog;
    protected Boolean successLog;
    protected Boolean deletionLog;
    protected Long jobPriorityHigherThanOrEquals;
    protected Long jobPriorityLowerThanOrEquals;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected String hostname;

    public HistoricJobLogQueryDto() {
    }

    public HistoricJobLogQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @EximeeBPMSQueryParam(value="logId")
    public void setLogId(String id) {
        this.id = id;
    }

    @EximeeBPMSQueryParam(value="jobId")
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @EximeeBPMSQueryParam(value="jobExceptionMessage")
    public void setJobExceptionMessage(String jobExceptionMessage) {
        this.jobExceptionMessage = jobExceptionMessage;
    }

    @EximeeBPMSQueryParam(value="jobDefinitionId")
    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    @EximeeBPMSQueryParam(value="jobDefinitionType")
    public void setJobDefinitionType(String jobDefinitionType) {
        this.jobDefinitionType = jobDefinitionType;
    }

    @EximeeBPMSQueryParam(value="jobDefinitionConfiguration")
    public void setJobDefinitionConfiguration(String jobDefinitionConfiguration) {
        this.jobDefinitionConfiguration = jobDefinitionConfiguration;
    }

    @EximeeBPMSQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIds) {
        this.activityIds = activityIds;
    }

    @EximeeBPMSQueryParam(value="failedActivityIdIn", converter=StringArrayConverter.class)
    public void setFailedActivityIdIn(String[] activityIds) {
        this.failedActivityIds = activityIds;
    }

    @EximeeBPMSQueryParam(value="executionIdIn", converter=StringArrayConverter.class)
    public void setExecutionIdIn(String[] executionIds) {
        this.executionIds = executionIds;
    }

    @EximeeBPMSQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @EximeeBPMSQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @EximeeBPMSQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @EximeeBPMSQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @EximeeBPMSQueryParam(value="creationLog", converter=BooleanConverter.class)
    public void setCreationLog(Boolean creationLog) {
        this.creationLog = creationLog;
    }

    @EximeeBPMSQueryParam(value="failureLog", converter=BooleanConverter.class)
    public void setFailureLog(Boolean failureLog) {
        this.failureLog = failureLog;
    }

    @EximeeBPMSQueryParam(value="successLog", converter=BooleanConverter.class)
    public void setSuccessLog(Boolean successLog) {
        this.successLog = successLog;
    }

    @EximeeBPMSQueryParam(value="deletionLog", converter=BooleanConverter.class)
    public void setDeletionLog(Boolean deletionLog) {
        this.deletionLog = deletionLog;
    }

    @EximeeBPMSQueryParam(value="jobPriorityHigherThanOrEquals", converter=LongConverter.class)
    public void setJobPriorityHigherThanOrEquals(Long jobPriorityHigherThanOrEquals) {
        this.jobPriorityHigherThanOrEquals = jobPriorityHigherThanOrEquals;
    }

    @EximeeBPMSQueryParam(value="jobPriorityLowerThanOrEquals", converter=LongConverter.class)
    public void setJobPriorityLowerThanOrEquals(Long jobPriorityLowerThanOrEquals) {
        this.jobPriorityLowerThanOrEquals = jobPriorityLowerThanOrEquals;
    }

    @EximeeBPMSQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @EximeeBPMSQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @EximeeBPMSQueryParam(value="hostname")
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricJobLogQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricJobLogQuery();
    }

    @Override
    protected void applyFilters(HistoricJobLogQuery query) {
        if (this.id != null) {
            query.logId(this.id);
        }
        if (this.jobId != null) {
            query.jobId(this.jobId);
        }
        if (this.jobExceptionMessage != null) {
            query.jobExceptionMessage(this.jobExceptionMessage);
        }
        if (this.jobDefinitionId != null) {
            query.jobDefinitionId(this.jobDefinitionId);
        }
        if (this.jobDefinitionType != null) {
            query.jobDefinitionType(this.jobDefinitionType);
        }
        if (this.jobDefinitionConfiguration != null) {
            query.jobDefinitionConfiguration(this.jobDefinitionConfiguration);
        }
        if (this.activityIds != null && this.activityIds.length > 0) {
            query.activityIdIn(this.activityIds);
        }
        if (this.failedActivityIds != null && this.failedActivityIds.length > 0) {
            query.failedActivityIdIn(this.failedActivityIds);
        }
        if (this.executionIds != null && this.executionIds.length > 0) {
            query.executionIdIn(this.executionIds);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.creationLog != null && this.creationLog.booleanValue()) {
            query.creationLog();
        }
        if (this.failureLog != null && this.failureLog.booleanValue()) {
            query.failureLog();
        }
        if (this.successLog != null && this.successLog.booleanValue()) {
            query.successLog();
        }
        if (this.deletionLog != null && this.deletionLog.booleanValue()) {
            query.deletionLog();
        }
        if (this.jobPriorityLowerThanOrEquals != null) {
            query.jobPriorityLowerThanOrEquals(this.jobPriorityLowerThanOrEquals.longValue());
        }
        if (this.jobPriorityHigherThanOrEquals != null) {
            query.jobPriorityHigherThanOrEquals(this.jobPriorityHigherThanOrEquals.longValue());
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.hostname != null && !this.hostname.isEmpty()) {
            query.hostname(this.hostname);
        }
    }

    @Override
    protected void applySortBy(HistoricJobLogQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_TIMESTAMP)) {
            query.orderByTimestamp();
        } else if (sortBy.equals(SORT_BY_JOB_ID)) {
            query.orderByJobId();
        } else if (sortBy.equals(SORT_BY_JOB_DUE_DATE)) {
            query.orderByJobDueDate();
        } else if (sortBy.equals(SORT_BY_JOB_RETRIES)) {
            query.orderByJobRetries();
        } else if (sortBy.equals(SORT_BY_JOB_PRIORITY)) {
            query.orderByJobPriority();
        } else if (sortBy.equals(SORT_BY_JOB_DEFINITION_ID)) {
            query.orderByJobDefinitionId();
        } else if (sortBy.equals(SORT_BY_ACTIVITY_ID)) {
            query.orderByActivityId();
        } else if (sortBy.equals(SORT_BY_EXECUTION_ID)) {
            query.orderByExecutionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_KEY)) {
            query.orderByProcessDefinitionKey();
        } else if (sortBy.equals(SORT_BY_DEPLOYMENT_ID)) {
            query.orderByDeploymentId();
        } else if (sortBy.equals(SORT_PARTIALLY_BY_OCCURRENCE)) {
            query.orderPartiallyByOccurrence();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        } else if (sortBy.equals(SORT_BY_HOSTNAME)) {
            query.orderByHostname();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TIMESTAMP);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_DUE_DATE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_RETRIES);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_PRIORITY);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_PARTIALLY_BY_OCCURRENCE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_HOSTNAME);
    }
}

