/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstanceQuery;
import org.eximeebpms.bpm.engine.rest.dto.AbstractQueryDto;
import org.eximeebpms.bpm.engine.rest.dto.EximeeBPMSQueryParam;
import org.eximeebpms.bpm.engine.rest.dto.converter.BooleanConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.eximeebpms.bpm.engine.rest.dto.converter.StringListConverter;
import org.eximeebpms.bpm.engine.rest.exception.InvalidRequestException;

public class HistoricVariableInstanceQueryDto
extends AbstractQueryDto<HistoricVariableInstanceQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_VARIABLE_NAME_VALUE = "variableName";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String caseInstanceId;
    protected String variableName;
    protected String variableNameLike;
    protected Object variableValue;
    protected Boolean variableValuesIgnoreCase;
    protected Boolean variableNamesIgnoreCase;
    protected String[] variableTypeIn;
    protected String[] executionIdIn;
    protected String[] taskIdIn;
    protected String[] activityInstanceIdIn;
    protected String[] caseExecutionIdIn;
    protected String[] caseActivityIdIn;
    protected String[] processInstanceIdIn;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected boolean includeDeleted;
    protected String[] variableNameIn;

    public HistoricVariableInstanceQueryDto() {
    }

    public HistoricVariableInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @EximeeBPMSQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @EximeeBPMSQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @EximeeBPMSQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @EximeeBPMSQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @EximeeBPMSQueryParam(value="variableName")
    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @EximeeBPMSQueryParam(value="variableNameLike")
    public void setVariableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
    }

    @EximeeBPMSQueryParam(value="variableValue")
    public void setVariableValue(Object variableValue) {
        this.variableValue = variableValue;
    }

    @EximeeBPMSQueryParam(value="variableTypeIn", converter=StringArrayConverter.class)
    public void setVariableTypeIn(String[] variableTypeIn) {
        this.variableTypeIn = variableTypeIn;
    }

    @EximeeBPMSQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    @EximeeBPMSQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @EximeeBPMSQueryParam(value="executionIdIn", converter=StringArrayConverter.class)
    public void setExecutionIdIn(String[] executionIdIn) {
        this.executionIdIn = executionIdIn;
    }

    @EximeeBPMSQueryParam(value="taskIdIn", converter=StringArrayConverter.class)
    public void setTaskIdIn(String[] taskIdIn) {
        this.taskIdIn = taskIdIn;
    }

    @EximeeBPMSQueryParam(value="processInstanceIdIn", converter=StringArrayConverter.class)
    public void setProcessInstanceIdIn(String[] processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    @EximeeBPMSQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @EximeeBPMSQueryParam(value="caseExecutionIdIn", converter=StringArrayConverter.class)
    public void setCaseExecutionIdIn(String[] caseExecutionIdIn) {
        this.caseExecutionIdIn = caseExecutionIdIn;
    }

    @EximeeBPMSQueryParam(value="caseActivityIdIn", converter=StringArrayConverter.class)
    public void setCaseActivityIdIn(String[] caseActivityIdIn) {
        this.caseActivityIdIn = caseActivityIdIn;
    }

    @EximeeBPMSQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @EximeeBPMSQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    @EximeeBPMSQueryParam(value="includeDeleted", converter=BooleanConverter.class)
    public void setIncludeDeleted(boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    @EximeeBPMSQueryParam(value="variableNameIn", converter=StringArrayConverter.class)
    public void setVariableNameIn(String[] variableNameIn) {
        this.variableNameIn = variableNameIn;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricVariableInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricVariableInstanceQuery();
    }

    @Override
    protected void applyFilters(HistoricVariableInstanceQuery query) {
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.variableName != null) {
            query.variableName(this.variableName);
        }
        if (this.variableNameLike != null) {
            query.variableNameLike(this.variableNameLike);
        }
        if (this.variableValue != null) {
            if (this.variableName != null) {
                query.variableValueEquals(this.variableName, this.variableValue);
            } else {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only a single variable value parameter specified: variable name and value are required to be able to query after a specific variable value.");
            }
        }
        if (this.variableTypeIn != null && this.variableTypeIn.length > 0) {
            query.variableTypeIn(this.variableTypeIn);
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.executionIdIn != null && this.executionIdIn.length > 0) {
            query.executionIdIn(this.executionIdIn);
        }
        if (this.taskIdIn != null && this.taskIdIn.length > 0) {
            query.taskIdIn(this.taskIdIn);
        }
        if (this.processInstanceIdIn != null && this.processInstanceIdIn.length > 0) {
            query.processInstanceIdIn(this.processInstanceIdIn);
        }
        if (this.activityInstanceIdIn != null && this.activityInstanceIdIn.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.caseExecutionIdIn != null && this.caseExecutionIdIn.length > 0) {
            query.caseExecutionIdIn(this.caseExecutionIdIn);
        }
        if (this.caseActivityIdIn != null && this.caseActivityIdIn.length > 0) {
            query.caseActivityIdIn(this.caseActivityIdIn);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.includeDeleted) {
            query.includeDeleted();
        }
        if (this.variableNameIn != null && this.variableNameIn.length > 0) {
            query.variableNameIn(this.variableNameIn);
        }
    }

    @Override
    protected void applySortBy(HistoricVariableInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_VARIABLE_NAME_VALUE)) {
            query.orderByVariableName();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

