/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.rest.dto.task;

import java.util.Date;
import lombok.Generated;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.form.CamundaFormRef;
import org.eximeebpms.bpm.engine.rest.dto.converter.DelegationStateConverter;
import org.eximeebpms.bpm.engine.task.DelegationState;
import org.eximeebpms.bpm.engine.task.Task;

public class TaskDto {
    private String id;
    private String name;
    private String assignee;
    private Date created;
    private Date due;
    private Date followUp;
    private Date lastUpdated;
    private String delegationState;
    private String description;
    private String executionId;
    private String owner;
    private String parentTaskId;
    private int priority;
    private String processDefinitionId;
    private String processInstanceId;
    private String taskDefinitionKey;
    private String caseExecutionId;
    private String caseInstanceId;
    private String caseDefinitionId;
    private boolean suspended;
    private String formKey;
    private CamundaFormRef camundaFormRef;
    private String tenantId;
    private String taskState;

    public TaskDto() {
    }

    public TaskDto(Task task) {
        this.id = task.getId();
        this.name = task.getName();
        this.assignee = task.getAssignee();
        this.created = task.getCreateTime();
        this.lastUpdated = task.getLastUpdated();
        this.due = task.getDueDate();
        this.followUp = task.getFollowUpDate();
        if (task.getDelegationState() != null) {
            this.delegationState = task.getDelegationState().toString();
        }
        this.description = task.getDescription();
        this.executionId = task.getExecutionId();
        this.owner = task.getOwner();
        this.parentTaskId = task.getParentTaskId();
        this.priority = task.getPriority();
        this.processDefinitionId = task.getProcessDefinitionId();
        this.processInstanceId = task.getProcessInstanceId();
        this.taskDefinitionKey = task.getTaskDefinitionKey();
        this.caseDefinitionId = task.getCaseDefinitionId();
        this.caseExecutionId = task.getCaseExecutionId();
        this.caseInstanceId = task.getCaseInstanceId();
        this.suspended = task.isSuspended();
        this.tenantId = task.getTenantId();
        this.taskState = task.getTaskState();
        try {
            this.formKey = task.getFormKey();
            this.camundaFormRef = task.getCamundaFormRef();
        }
        catch (BadUserRequestException badUserRequestException) {
            // empty catch block
        }
    }

    public static TaskDto fromEntity(Task task) {
        TaskDto dto = new TaskDto();
        dto.id = task.getId();
        dto.name = task.getName();
        dto.assignee = task.getAssignee();
        dto.created = task.getCreateTime();
        dto.lastUpdated = task.getLastUpdated();
        dto.due = task.getDueDate();
        dto.followUp = task.getFollowUpDate();
        if (task.getDelegationState() != null) {
            dto.delegationState = task.getDelegationState().toString();
        }
        dto.description = task.getDescription();
        dto.executionId = task.getExecutionId();
        dto.owner = task.getOwner();
        dto.parentTaskId = task.getParentTaskId();
        dto.priority = task.getPriority();
        dto.processDefinitionId = task.getProcessDefinitionId();
        dto.processInstanceId = task.getProcessInstanceId();
        dto.taskDefinitionKey = task.getTaskDefinitionKey();
        dto.caseDefinitionId = task.getCaseDefinitionId();
        dto.caseExecutionId = task.getCaseExecutionId();
        dto.caseInstanceId = task.getCaseInstanceId();
        dto.suspended = task.isSuspended();
        dto.tenantId = task.getTenantId();
        dto.taskState = task.getTaskState();
        try {
            dto.formKey = task.getFormKey();
            dto.camundaFormRef = task.getCamundaFormRef();
        }
        catch (BadUserRequestException badUserRequestException) {
            // empty catch block
        }
        return dto;
    }

    public void updateTask(Task task) {
        task.setName(this.getName());
        task.setDescription(this.getDescription());
        task.setPriority(this.getPriority());
        task.setAssignee(this.getAssignee());
        task.setOwner(this.getOwner());
        DelegationState state = null;
        if (this.getDelegationState() != null) {
            DelegationStateConverter converter = new DelegationStateConverter();
            state = converter.convertQueryParameterToType(this.getDelegationState());
        }
        task.setDelegationState(state);
        task.setDueDate(this.getDue());
        task.setFollowUpDate(this.getFollowUp());
        task.setParentTaskId(this.getParentTaskId());
        task.setCaseInstanceId(this.getCaseInstanceId());
        task.setTenantId(this.getTenantId());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAssignee() {
        return this.assignee;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public Date getDue() {
        return this.due;
    }

    @Generated
    public Date getFollowUp() {
        return this.followUp;
    }

    @Generated
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Generated
    public String getDelegationState() {
        return this.delegationState;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Generated
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Generated
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    @Generated
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    @Generated
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Generated
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    @Generated
    public boolean isSuspended() {
        return this.suspended;
    }

    @Generated
    public String getFormKey() {
        return this.formKey;
    }

    @Generated
    public CamundaFormRef getCamundaFormRef() {
        return this.camundaFormRef;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getTaskState() {
        return this.taskState;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @Generated
    public void setDue(Date due) {
        this.due = due;
    }

    @Generated
    public void setFollowUp(Date followUp) {
        this.followUp = followUp;
    }

    @Generated
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Generated
    public void setDelegationState(String delegationState) {
        this.delegationState = delegationState;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }
}

